/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.render;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.Resolution;
import com.leclowndu93150.wakes.debug.WakesDebugInfo;
import com.leclowndu93150.wakes.render.WakeTexture;
import com.leclowndu93150.wakes.simulation.Brick;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WakeRenderer {
    public static Map<Resolution, WakeTexture> wakeTextures = null;

    private static void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res, true), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res, true), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res, true));
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        WakeHandler wakeHandler;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue()) {
            WakesDebugInfo.quadsRendered = 0;
            return;
        }
        if (wakeTextures == null) {
            WakeRenderer.initTextures();
        }
        if ((wakeHandler = (WakeHandler)WakeHandler.getInstance().orElse(null)) == null || WakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<Brick> bricks = wakeHandler.getVisible(event.getFrustum(), Brick.class);
        Matrix4f matrix = event.getPoseStack().m_85850_().m_252922_();
        RenderSystem.enableBlend();
        Minecraft.m_91087_().f_91063_.m_109155_().m_118087_();
        Resolution resolution = WakeHandler.resolution;
        int n = 0;
        long tRendering = System.nanoTime();
        for (Brick brick : bricks) {
            WakeRenderer.render(matrix, event.getCamera(), brick, wakeTextures.get((Object)resolution));
            ++n;
        }
        WakesDebugInfo.renderingTime.add(System.nanoTime() - tRendering);
        WakesDebugInfo.quadsRendered = n;
    }

    private static void render(Matrix4f matrix, Camera camera, Brick brick, WakeTexture texture) {
        if (!brick.hasPopulatedPixels) {
            return;
        }
        texture.loadTexture(brick.imgPtr);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Vector3f pos = brick.pos.m_82549_(camera.m_90583_().m_82548_()).m_252839_().add(0.0f, 0.8888889f, 0.0f);
        buffer.m_252986_(matrix, pos.x, pos.y, pos.z).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, pos.x, pos.y, pos.z + (float)brick.dim).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, pos.x + (float)brick.dim, pos.y, pos.z + (float)brick.dim).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, pos.x + (float)brick.dim, pos.y, pos.z).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        RenderSystem.disableCull();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.enableCull();
    }
}

