/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vazkii.botania.api.ServiceUtil;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.configdata.ConfigDataManager;
import vazkii.botania.api.corporea.CorporeaNodeDetector;
import vazkii.botania.api.internal.DummyManaNetwork;
import vazkii.botania.api.internal.ManaNetwork;

public interface BotaniaAPI {
    public static final String MODID = "botania";
    public static final String GOG_MODID = "gardenofglass";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"botania");
    public static final BotaniaAPI INSTANCE = ServiceUtil.findService(BotaniaAPI.class, () -> new BotaniaAPI(){});
    public static final ArmorMaterial DUMMY_ARMOR_MATERIAL = new ArmorMaterial(){

        public int m_266425_(@NotNull ArmorItem.Type type) {
            return 0;
        }

        public int m_7366_(@NotNull ArmorItem.Type type) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        public String m_6082_() {
            return "missingno";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    };
    public static final Tier DUMMY_ITEM_TIER = new Tier(){

        public int m_6609_() {
            return 0;
        }

        public float m_6624_() {
            return 0.0f;
        }

        public float m_6631_() {
            return 0.0f;
        }

        public int m_6604_() {
            return 0;
        }

        public int m_6601_() {
            return 0;
        }

        @NotNull
        public Ingredient m_6282_() {
            return Ingredient.f_43901_;
        }
    };

    public static BotaniaAPI instance() {
        return INSTANCE;
    }

    default public int apiVersion() {
        return 0;
    }

    @Nullable
    default public Registry<Brew> getBrewRegistry() {
        return null;
    }

    default public Map<ResourceLocation, Function<DyeColor, Block>> getPaintableBlocks() {
        return Collections.emptyMap();
    }

    default public void registerPaintableBlock(Block block, Function<DyeColor, Block> transformer) {
        this.registerPaintableBlock(BuiltInRegistries.f_256975_.m_7981_((Object)block), transformer);
    }

    default public void registerPaintableBlock(ResourceLocation blockId, Function<DyeColor, Block> transformer) {
    }

    default public ArmorMaterial getManasteelArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public ArmorMaterial getElementiumArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public ArmorMaterial getManaweaveArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public ArmorMaterial getTerrasteelArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public Tier getManasteelItemTier() {
        return DUMMY_ITEM_TIER;
    }

    default public Tier getElementiumItemTier() {
        return DUMMY_ITEM_TIER;
    }

    default public Tier getTerrasteelItemTier() {
        return DUMMY_ITEM_TIER;
    }

    default public ManaNetwork getManaNetworkInstance() {
        return DummyManaNetwork.instance;
    }

    default public Container getAccessoriesInventory(Player player) {
        return new SimpleContainer(0);
    }

    default public void breakOnAllCursors(Player player, ItemStack stack, BlockPos pos, Direction side) {
    }

    default public boolean hasSolegnoliaAround(Entity e) {
        return false;
    }

    default public void sparkleFX(Level world, double x, double y, double z, float r, float g, float b, float size, int m) {
    }

    default public void registerCorporeaNodeDetector(CorporeaNodeDetector detector) {
    }

    default public ConfigDataManager getConfigData() {
        return null;
    }

    default public void setConfigData(ConfigDataManager configDataManager) {
    }
}

