/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.ImportPaintingPacket;

public class CommandImport {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"paintimport").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandImport.paintImport((CommandSourceStack)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int paintImport(CommandSourceStack stack, String name) {
        XercaPaint.LOGGER.debug("Paint import called. name: " + name);
        ImportPaintingPacket pack = new ImportPaintingPacket(name);
        try {
            ServerPlayer player = stack.m_81375_();
            XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)pack);
        }
        catch (CommandSyntaxException e) {
            XercaPaint.LOGGER.debug("Command executor is not a player");
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public static void doImport(CompoundTag tag, ServerPlayer player) {
        if (!tag.m_128425_("name", 8)) {
            player.m_213846_((Component)Component.m_237115_((String)"xercapaint.import.fail.5").m_130940_(ChatFormatting.RED));
            XercaPaint.LOGGER.warn("Broken paint file");
            return;
        }
        String name = tag.m_128461_("name");
        if (!name.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}_[0-9]+$")) {
            player.m_213846_((Component)Component.m_237115_((String)"xercapaint.import.fail.5").m_130940_(ChatFormatting.RED));
            XercaPaint.LOGGER.warn("Broken paint file");
            return;
        }
        if (tag.m_128425_("author", 8) && !tag.m_128425_("title", 8) || !tag.m_128425_("author", 8) && tag.m_128425_("title", 8)) {
            player.m_213846_((Component)Component.m_237115_((String)"xercapaint.import.fail.5").m_130940_(ChatFormatting.RED));
            XercaPaint.LOGGER.warn("Broken paint file");
            return;
        }
        if (tag.m_128425_("title", 8) && tag.m_128461_("title").length() > 16) {
            tag.m_128359_("title", tag.m_128461_("title").substring(0, 16));
        }
        if (tag.m_128425_("author", 8) && tag.m_128461_("author").length() > 16) {
            tag.m_128359_("author", tag.m_128461_("author").substring(0, 16));
        }
        if (!tag.m_128425_("v", 3)) {
            tag.m_128405_("v", 1);
        }
        byte canvasType = tag.m_128445_("ct");
        tag.m_128473_("ct");
        if (tag.m_128451_("generation") > 0) {
            tag.m_128405_("generation", tag.m_128451_("generation") + 1);
        }
        if (player.m_7500_()) {
            ItemStack itemStack;
            switch (CanvasType.fromByte(canvasType)) {
                case SMALL: {
                    itemStack = new ItemStack((ItemLike)Items.ITEM_CANVAS.get());
                    break;
                }
                case LONG: {
                    itemStack = new ItemStack((ItemLike)Items.ITEM_CANVAS_LONG.get());
                    break;
                }
                case TALL: {
                    itemStack = new ItemStack((ItemLike)Items.ITEM_CANVAS_TALL.get());
                    break;
                }
                case LARGE: {
                    itemStack = new ItemStack((ItemLike)Items.ITEM_CANVAS_LARGE.get());
                    break;
                }
                default: {
                    XercaPaint.LOGGER.error("Invalid canvas type");
                    return;
                }
            }
            itemStack.m_41751_(tag);
            player.m_36356_(itemStack);
        } else {
            ItemStack mainHand = player.m_21205_();
            ItemStack offhand = player.m_21206_();
            if (!(mainHand.m_41720_() instanceof ItemCanvas) || mainHand.m_41782_() && mainHand.m_41783_() != null && !mainHand.m_41783_().m_128456_()) {
                player.m_213846_((Component)Component.m_237115_((String)"xercapaint.import.fail.1").m_130940_(ChatFormatting.RED));
                return;
            }
            if (((ItemCanvas)mainHand.m_41720_()).getCanvasType() != CanvasType.fromByte(canvasType)) {
                Component type = Objects.requireNonNull((ItemCanvas)((Object)Items.ITEM_CANVAS.get())).m_7626_(ItemStack.f_41583_);
                switch (CanvasType.fromByte(canvasType)) {
                    case LONG: {
                        type = Objects.requireNonNull((ItemCanvas)((Object)Items.ITEM_CANVAS_LONG.get())).m_7626_(ItemStack.f_41583_);
                        break;
                    }
                    case TALL: {
                        type = Objects.requireNonNull((ItemCanvas)((Object)Items.ITEM_CANVAS_TALL.get())).m_7626_(ItemStack.f_41583_);
                        break;
                    }
                    case LARGE: {
                        type = Objects.requireNonNull((ItemCanvas)((Object)Items.ITEM_CANVAS_LARGE.get())).m_7626_(ItemStack.f_41583_);
                    }
                }
                player.m_213846_((Component)Component.m_237110_((String)"xercapaint.import.fail.2", (Object[])new Object[]{type}).m_130940_(ChatFormatting.RED));
                return;
            }
            if (!ItemPalette.isFull(offhand)) {
                player.m_213846_((Component)Component.m_237115_((String)"xercapaint.import.fail.3").m_130940_(ChatFormatting.RED));
                return;
            }
            mainHand.m_41751_(tag);
        }
        player.m_213846_((Component)Component.m_237115_((String)"xercapaint.import.success").m_130940_(ChatFormatting.GREEN));
    }
}

