/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.recipe.enchanting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.lyof.sortilege.config.ConfigEntries;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EnchantingCatalyst {
    public static final Map<class_1792, List<class_1887>> CATALYSTS = new HashMap<class_1792, List<class_1887>>();

    public static void clear() {
        CATALYSTS.clear();
    }

    public static void register(class_1792 catalyst, List<class_1887> enchants) {
        if (CATALYSTS.containsKey(catalyst)) {
            CATALYSTS.get(catalyst).addAll(enchants);
        } else {
            CATALYSTS.put(catalyst, enchants);
        }
        CATALYSTS.replace(catalyst, new ArrayList(new HashSet(CATALYSTS.get(catalyst))));
    }

    public static boolean isEmpty() {
        return CATALYSTS.isEmpty();
    }

    public static Map<class_1887, Integer> getEnchantments(class_1799 catalyst) {
        if (catalyst.method_7909() instanceof class_1772 && ConfigEntries.bookCatalysts) {
            return class_1890.method_8222((class_1799)catalyst);
        }
        HashMap<class_1887, Integer> result = new HashMap<class_1887, Integer>();
        for (class_1887 enchant : CATALYSTS.getOrDefault(catalyst.method_7909(), List.of())) {
            result.put(enchant, 1);
        }
        return result;
    }

    public static boolean isCatalyst(class_1799 item) {
        return !EnchantingCatalyst.getEnchantments(item).isEmpty();
    }

    public static void read(JsonObject json) {
        if (json.has("item") && json.has("enchantments") && json.get("enchantments").isJsonArray()) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("item").getAsString()));
            List<class_1887> enchants = json.get("enchantments").getAsJsonArray().asList().stream().map(id -> (class_1887)class_7923.field_41176.method_10223(new class_2960(id.getAsString()))).filter(Objects::nonNull).toList();
            EnchantingCatalyst.register(item, enchants);
        }
    }

    public static void read(class_2540 packet) {
        class_1792 key = (class_1792)class_7923.field_41178.method_10223(packet.method_10810());
        int enchants = packet.readInt();
        ArrayList<class_1887> value = new ArrayList<class_1887>();
        for (int j = 0; j < enchants; ++j) {
            value.add((class_1887)class_7923.field_41176.method_10223(packet.method_10810()));
        }
        CATALYSTS.putIfAbsent(key, value);
    }

    public static void write(List<class_2540> packets) {
        for (Map.Entry<class_1792, List<class_1887>> entry : CATALYSTS.entrySet()) {
            class_2540 packet = PacketByteBufs.create();
            packet.writeInt(1);
            packet.method_10812(class_7923.field_41178.method_10221((Object)entry.getKey()));
            packet.writeInt(entry.getValue().size());
            for (class_1887 enchant : entry.getValue()) {
                packet.method_10812(class_7923.field_41176.method_10221((Object)enchant));
            }
            packets.add(packet);
        }
    }
}

