/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.recipe.crafting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_161;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public abstract class RecipeLock {
    public static RecipeLock NONE = new RecipeLock(){

        @Override
        public boolean matches(class_3222 player) {
            return false;
        }

        @Override
        public class_5250 getFailMessage(class_3222 player) {
            return class_2561.method_43473();
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_5250 getFailMessage() {
            return class_2561.method_43473();
        }
    };
    protected static Map<String, RecipeLock> RECIPE_LOCKS = new HashMap<String, RecipeLock>();
    private static final Map<String, class_5250> TITLES = new HashMap<String, class_5250>();

    public abstract boolean matches(class_3222 var1);

    public abstract class_5250 getFailMessage(class_3222 var1);

    @Environment(value=EnvType.CLIENT)
    public abstract class_5250 getFailMessage();

    public static void clear() {
        RECIPE_LOCKS.clear();
    }

    public static void register(String recipe, RecipeLock lock) {
        RECIPE_LOCKS.putIfAbsent(recipe, lock);
    }

    public static RecipeLock get(String recipe) {
        return RECIPE_LOCKS.getOrDefault(recipe, NONE);
    }

    public static Map<String, RecipeLock> getAll() {
        return RECIPE_LOCKS;
    }

    public static void read(class_2540 packet) {
        String id = packet.method_19772();
        boolean isTranslatable = packet.readBoolean();
        String title = packet.method_19772();
        TITLES.putIfAbsent(id, class_2561.method_43469((String)"sortilege.crafting.requires_advancement", (Object[])new Object[]{class_2561.method_43470((String)"[").method_10852((class_2561)(isTranslatable ? class_2561.method_43471((String)title) : class_2561.method_43470((String)title))).method_27693("]").method_27692(class_124.field_1060)}));
    }

    public static void write(List<class_2540> packets, class_3222 player) {
        for (RecipeLock lock : RECIPE_LOCKS.values()) {
            String string;
            if (!(lock instanceof AdvancementLock)) continue;
            AdvancementLock advancementLock = (AdvancementLock)lock;
            class_161 advc = Objects.requireNonNull(player.method_5682()).method_3851().method_12896(new class_2960(advancementLock.id));
            if (advc == null || advc.method_686() == null) continue;
            class_2540 packet = PacketByteBufs.create();
            packet.writeInt(3);
            packet.method_10814(advancementLock.id);
            class_2561 title = advc.method_686().method_811();
            packet.writeBoolean(title.method_10851() instanceof class_2588);
            class_7417 class_74172 = title.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 content = (class_2588)class_74172;
                string = content.method_11022();
            } else {
                string = title.getString();
            }
            packet.method_10814(string);
            packets.add(packet);
        }
    }

    public static class AdvancementLock
    extends RecipeLock {
        public String id;

        public AdvancementLock(String id) {
            this.id = id;
        }

        @Override
        public boolean matches(class_3222 player) {
            class_161 advc = Objects.requireNonNull(player.method_5682()).method_3851().method_12896(new class_2960(this.id));
            return advc != null && !player.method_14236().method_12882(advc).method_740();
        }

        @Override
        public class_5250 getFailMessage(class_3222 player) {
            class_161 advc = Objects.requireNonNull(player.method_5682()).method_3851().method_12896(new class_2960(this.id));
            if (advc == null) {
                return class_2561.method_43473();
            }
            return class_2561.method_43469((String)"sortilege.crafting.requires_advancement", (Object[])new Object[]{advc.method_684()});
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_5250 getFailMessage() {
            if (!TITLES.containsKey(this.id)) {
                return class_2561.method_43473();
            }
            return TITLES.get(this.id);
        }

        public String toString() {
            return "AdvancementLock{id='" + this.id + "'}";
        }
    }

    public static class LevelLock
    extends RecipeLock {
        public int lvl;

        public LevelLock(int lvl) {
            this.lvl = lvl;
        }

        @Override
        public boolean matches(class_3222 player) {
            return player.field_7520 < this.lvl;
        }

        @Override
        public class_5250 getFailMessage(class_3222 player) {
            return class_2561.method_43469((String)"sortilege.crafting.requires_level", (Object[])new Object[]{this.lvl});
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_5250 getFailMessage() {
            return class_2561.method_43469((String)"sortilege.crafting.requires_level", (Object[])new Object[]{class_2561.method_43470((String)("" + this.lvl)).method_27692(class_124.field_1054)});
        }

        public String toString() {
            return "LevelLock{lvl=" + this.lvl + "}";
        }
    }
}

