/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.recipe.brewing;

import com.google.gson.JsonObject;
import java.util.Random;
import java.util.stream.Stream;
import net.lyof.sortilege.recipe.ModRecipeTypes;
import net.lyof.sortilege.recipe.brewing.BetterBrewingRegistry;
import net.lyof.sortilege.recipe.brewing.custom.ItemBrewingRecipe;
import net.lyof.sortilege.recipe.brewing.custom.PotionBrewingRecipe;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public abstract class BrewingRecipe
implements class_1860<class_1277> {
    private final class_2960 id;

    public BrewingRecipe(class_2960 id) {
        this.id = id;
    }

    public abstract boolean isInput(class_1799 var1);

    public abstract boolean isIngredient(class_1799 var1);

    public abstract class_1799 craft(class_1799 var1, class_1799 var2);

    public abstract class_1799 getIngredient();

    public abstract class_1799 getInput();

    public abstract class_1799 getInput(Random var1);

    public abstract class_1799 getOutput();

    public class_2960 method_8114() {
        return this.id;
    }

    public boolean matches(class_1277 inventory, class_1937 world) {
        return this.isIngredient(inventory.method_5438(3)) && Stream.of(0, 1, 2).anyMatch(i -> this.isInput(inventory.method_5438(i.intValue())));
    }

    public class_1799 craft(class_1277 inventory, class_5455 registryManager) {
        for (int i = 0; i < 3; ++i) {
            class_1799 input = inventory.method_5438(i);
            class_1799 ingredient = inventory.method_5438(3);
            if (!this.isInput(input) || !this.isIngredient(ingredient)) continue;
            return this.craft(input, ingredient);
        }
        return class_1799.field_8037;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.getOutput();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.BREWING;
    }

    public static class Serializer
    implements class_1865<BrewingRecipe> {
        public BrewingRecipe read(class_2960 id, JsonObject json) {
            if (!(json.has("input") && json.has("ingredient") && json.has("output"))) {
                return null;
            }
            if (json.get("input").isJsonObject() && json.get("input").getAsJsonObject().has("potion")) {
                class_1842 in = (class_1842)class_7923.field_41179.method_10223(new class_2960(json.get("input").getAsJsonObject().get("potion").getAsString()));
                class_1792 add = (class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("ingredient").getAsJsonObject().get("item").getAsString()));
                class_1842 out = (class_1842)class_7923.field_41179.method_10223(new class_2960(json.get("output").getAsJsonObject().get("potion").getAsString()));
                PotionBrewingRecipe recipe = new PotionBrewingRecipe(in, add, out, id);
                BetterBrewingRegistry.register(recipe);
                return recipe;
            }
            class_1792 in = (class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("input").getAsJsonObject().get("item").getAsString()));
            class_1792 add = (class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("ingredient").getAsJsonObject().get("item").getAsString()));
            class_1792 out = (class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("output").getAsJsonObject().get("item").getAsString()));
            ItemBrewingRecipe recipe = new ItemBrewingRecipe(in, add, out, id);
            BetterBrewingRegistry.register(recipe);
            return recipe;
        }

        public BrewingRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            int type = packetByteBuf.readInt();
            switch (type) {
                case 0: {
                    class_1792 ini = (class_1792)class_7923.field_41178.method_10223(packetByteBuf.method_10810());
                    class_1792 addi = (class_1792)class_7923.field_41178.method_10223(packetByteBuf.method_10810());
                    class_1792 outi = (class_1792)class_7923.field_41178.method_10223(packetByteBuf.method_10810());
                    return new ItemBrewingRecipe(ini, addi, outi, identifier);
                }
                case 1: {
                    class_1842 inp = (class_1842)class_7923.field_41179.method_10223(packetByteBuf.method_10810());
                    class_1792 addp = (class_1792)class_7923.field_41178.method_10223(packetByteBuf.method_10810());
                    class_1842 outp = (class_1842)class_7923.field_41179.method_10223(packetByteBuf.method_10810());
                    return new PotionBrewingRecipe(inp, addp, outp, identifier);
                }
            }
            return null;
        }

        public void write(class_2540 packetByteBuf, BrewingRecipe recipe) {
            if (recipe instanceof ItemBrewingRecipe) {
                ItemBrewingRecipe itemRecipe = (ItemBrewingRecipe)recipe;
                packetByteBuf.writeInt(0);
                packetByteBuf.method_10812(class_7923.field_41178.method_10221((Object)itemRecipe.input));
                packetByteBuf.method_10812(class_7923.field_41178.method_10221((Object)itemRecipe.ingredient));
                packetByteBuf.method_10812(class_7923.field_41178.method_10221((Object)itemRecipe.output));
            } else if (recipe instanceof PotionBrewingRecipe) {
                PotionBrewingRecipe potionRecipe = (PotionBrewingRecipe)recipe;
                packetByteBuf.writeInt(1);
                packetByteBuf.method_10812(class_7923.field_41179.method_10221((Object)potionRecipe.input));
                packetByteBuf.method_10812(class_7923.field_41178.method_10221((Object)potionRecipe.ingredient));
                packetByteBuf.method_10812(class_7923.field_41179.method_10221((Object)potionRecipe.output));
            }
        }
    }
}

