/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.item.custom.potion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.item.custom.potion.PotionShenanigans;
import net.lyof.sortilege.mixin.accessor.RegistryEntryReferenceAccessor;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1842;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class CustomPotionData {
    public class_2960 potion;
    public List<class_1293> effects;
    public int drinkingTime;
    public int cooldown;
    public int stackSize;
    public boolean create;
    private static final List<CustomPotionData> INSTANCES = new ArrayList<CustomPotionData>();
    private static final Map<class_1842, CustomPotionData> CACHE = new HashMap<class_1842, CustomPotionData>();
    private static final Map<class_2960, class_1842> REGISTRY = new HashMap<class_2960, class_1842>();
    public static final List<class_2960> MODELS = new ArrayList<class_2960>();

    public CustomPotionData(class_2960 potion, List<class_1293> effects, int drinkingTime, int cooldown, int stackSize, boolean create) {
        this.potion = potion;
        this.effects = effects;
        this.drinkingTime = drinkingTime;
        this.cooldown = cooldown;
        this.stackSize = stackSize;
        this.create = create;
        if (this.create && !class_7923.field_41179.method_10250(potion)) {
            REGISTRY.putIfAbsent(potion, new class_1842("custom." + potion.method_12836() + "." + potion.method_12832(), new class_1293[0]));
        }
    }

    public static void read(JsonObject json) {
        if (json.has("potion")) {
            INSTANCES.add(new CustomPotionData(new class_2960(json.get("potion").getAsString()), json.has("effects") && json.get("effects").isJsonArray() ? CustomPotionData.readEffectList(json.get("effects").getAsJsonArray()) : null, json.has("drinking_time") ? json.get("drinking_time").getAsInt() : ConfigEntries.potionDrinkingTime, json.has("cooldown") ? json.get("cooldown").getAsInt() : ConfigEntries.potionCooldown, json.has("stack_size") ? json.get("stack_size").getAsInt() : ConfigEntries.potionStackSize, json.has("create") && json.get("create").getAsBoolean()));
        }
    }

    public static List<class_1293> readEffectList(JsonArray json) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        for (JsonElement e : json) {
            class_1291 effect;
            JsonObject o;
            if (!e.isJsonObject() || !(o = e.getAsJsonObject()).has("effect") || !o.has("duration") || !o.has("amplifier") || (effect = (class_1291)class_7923.field_41174.method_10223(new class_2960(o.get("effect").getAsString()))) == null) continue;
            int duration = o.get("duration").getAsInt();
            int amplifier = o.get("amplifier").getAsInt();
            effects.add(new class_1293(effect, duration, amplifier));
        }
        return effects;
    }

    public static void read(class_2540 packet) {
        ArrayList<class_1293> effects;
        class_2960 potion = packet.method_10810();
        int stackSize = packet.readInt();
        int drinkingTime = packet.readInt();
        int cooldown = packet.readInt();
        boolean create = packet.readBoolean();
        int size = packet.readInt();
        if (size == -1) {
            effects = null;
        } else {
            effects = new ArrayList<class_1293>();
            for (int j = 0; j < size; ++j) {
                class_1291 effect = (class_1291)class_7923.field_41174.method_10223(packet.method_10810());
                int duration = packet.readInt();
                int amplifier = packet.readInt();
                effects.add(new class_1293(effect, duration, amplifier));
            }
        }
        INSTANCES.add(new CustomPotionData(potion, effects, drinkingTime, cooldown, stackSize, create));
    }

    public static void write(List<class_2540> packets) {
        for (CustomPotionData data : INSTANCES) {
            class_2540 packet = PacketByteBufs.create();
            packet.writeInt(2);
            packet.method_10812(data.potion);
            packet.writeInt(data.stackSize);
            packet.writeInt(data.drinkingTime);
            packet.writeInt(data.cooldown);
            packet.writeBoolean(data.create);
            if (data.effects == null) {
                packet.writeInt(-1);
            } else {
                packet.writeInt(data.effects.size());
                for (class_1293 effect : data.effects) {
                    packet.method_10812(class_7923.field_41174.method_10221((Object)effect.method_5579()));
                    packet.writeInt(effect.method_5584());
                    packet.writeInt(effect.method_5578());
                }
            }
            packets.add(packet);
        }
    }

    @Nullable
    public static CustomPotionData get(class_1842 potion) {
        if (!ConfigEntries.potionData) {
            return null;
        }
        if (CACHE.containsKey(potion)) {
            return CACHE.get(potion);
        }
        CustomPotionData result = INSTANCES.stream().filter(data -> data.potion.equals((Object)class_7923.field_41179.method_10221((Object)potion))).findFirst().orElse(null);
        CACHE.put(potion, result);
        return result;
    }

    public static void clear() {
        INSTANCES.clear();
        CACHE.clear();
        for (class_1842 potion : class_7923.field_41179) {
            ((PotionShenanigans)potion).sorti$resetPotionCache();
        }
        REGISTRY.clear();
    }

    public static boolean isEmpty() {
        return INSTANCES.isEmpty();
    }

    public static class_1842 get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public static class_2960 getId(class_1842 potion) {
        for (Map.Entry<class_2960, class_1842> entry : REGISTRY.entrySet()) {
            if (entry.getValue() != potion) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T> List<class_6880.class_6883<T>> getRegistry(class_7876<T> owner) {
        return REGISTRY.entrySet().stream().map(entry -> {
            class_6880.class_6883 ref = class_6880.class_6883.method_40234((class_7876)owner, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41215, (class_2960)((class_2960)entry.getKey())));
            ((RegistryEntryReferenceAccessor)ref).setValue(entry.getValue());
            return ref;
        }).toList();
    }
}

