/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.attribute.ModAttributes;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.config.ModConfig;
import net.lyof.sortilege.enchant.ModEnchants;
import net.lyof.sortilege.enchant.staff.ElementalStaffEnchantment;
import net.lyof.sortilege.item.custom.rendering.AddedRenderItem;
import net.lyof.sortilege.item.custom.rendering.MockItemRenderer;
import net.lyof.sortilege.particle.ModParticles;
import net.lyof.sortilege.setup.ModTags;
import net.lyof.sortilege.util.ItemHelper;
import net.lyof.sortilege.util.MathHelper;
import net.lyof.sortilege.util.XPHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_5253;
import net.minecraft.class_5536;
import net.minecraft.class_5620;
import net.minecraft.class_5630;
import net.minecraft.class_6025;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaffItem
extends class_1831
implements class_1768,
AddedRenderItem {
    private static final float[] COLOR_NONE = new float[]{1.0f, 1.0f, 1.0f};
    @Nullable
    public ModConfig.StaffInfo rawInfos;
    public float damage;
    public int pierce;
    public int range;
    public int cooldown;
    public int charge;
    public int xp_cost;
    @Nullable
    public class_1268 handSave;
    private static final String OVERCHARGE_NBT = "sortilegeOvercharge";
    private static final class_2960 COLOR_OVERLAY = Sortilege.makeID("textures/models/staff/glint.png");

    public StaffItem(ModConfig.StaffInfo stats, FabricItemSettings settings) {
        this(stats.tier, stats.damage, stats.pierce, stats.range, stats.durability, stats.cooldown, stats.charge_time, stats.xp_cost, stats.fireRes ? settings.fireproof() : settings);
        this.rawInfos = stats;
    }

    public StaffItem(class_1832 tier, int damage, int targets, int range, int dura, int cooldown, int charge, int xp_cost, FabricItemSettings settings) {
        super(tier, (class_1792.class_1793)settings.maxDamage(dura));
        this.damage = damage;
        this.pierce = targets;
        this.range = range;
        this.cooldown = cooldown;
        this.charge = charge;
        this.xp_cost = xp_cost;
        class_5620.field_27776.put(this, class_5620.field_27782);
    }

    public int getXPCost(class_1799 itemstack) {
        return Math.max(this.xp_cost + ItemHelper.getEnchantLevel(ModEnchants.IGNORANCE_CURSE, itemstack) - ItemHelper.getEnchantLevel(ModEnchants.WISDOM, itemstack), 0);
    }

    public float getAttackDamage(class_1799 stack) {
        return this.damage + (float)ItemHelper.getEnchantLevel(ModEnchants.POTENCY, stack);
    }

    public int getAttackRange(class_1799 stack) {
        return this.range + ItemHelper.getEnchantLevel(ModEnchants.STABILITY, stack) * 2;
    }

    public int getPierce(class_1799 stack) {
        return this.pierce + ItemHelper.getEnchantLevel(ModEnchants.CHAINING, stack);
    }

    private int getCooldown(class_1799 stack, class_1657 player) {
        float multiplier = 1.0f - (float)ItemHelper.getEnchantLevel(ModEnchants.FOCUS, stack) * 0.05f;
        if (stack.method_31573(ModTags.Items.XP_BOOSTED)) {
            multiplier -= (float)player.field_7520 / 200.0f;
        }
        multiplier = Math.max(multiplier, 0.0f);
        return (int)((float)this.cooldown * multiplier);
    }

    public List<float[]> getBeamColors(class_1799 stack, Set<ElementalStaffEnchantment> elements) {
        ArrayList<float[]> result = new ArrayList<float[]>();
        int rgb = this.method_7800(stack);
        float[] color = new float[]{(float)class_5253.class_5254.method_27765((int)rgb) / 255.0f, (float)class_5253.class_5254.method_27766((int)rgb) / 255.0f, (float)class_5253.class_5254.method_27767((int)rgb) / 255.0f};
        if (rgb == 10511680) {
            if (this.rawInfos != null && !this.rawInfos.colors.isEmpty()) {
                return this.rawInfos.colors;
            }
            for (ElementalStaffEnchantment element : elements) {
                result.addAll(element.colors);
            }
            if (result.isEmpty()) {
                result.add(COLOR_NONE);
            }
            if (stack.method_7942()) {
                result.add(new float[]{0.7f, 0.0f, 1.0f});
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                result.add(new float[]{(float)((double)color[0] + Math.random() * 0.1 - 0.05), (float)((double)color[1] + Math.random() * 0.1 - 0.05), (float)((double)color[2] + Math.random() * 0.1 - 0.05)});
            }
        }
        return result;
    }

    public Set<ElementalStaffEnchantment> getElements(class_1799 stack) {
        HashSet<ElementalStaffEnchantment> elements = new HashSet<ElementalStaffEnchantment>();
        for (class_1887 enchant : class_1890.method_8222((class_1799)stack).keySet()) {
            if (!(enchant instanceof ElementalStaffEnchantment)) continue;
            ElementalStaffEnchantment element = (ElementalStaffEnchantment)enchant;
            elements.add(element);
        }
        return elements;
    }

    public int getOvercharge(class_1799 stack) {
        if (!stack.method_7985()) {
            return 0;
        }
        return stack.method_7948().method_10550(OVERCHARGE_NBT);
    }

    public void setOvercharge(class_1799 stack, int value) {
        stack.method_7948().method_10569(OVERCHARGE_NBT, Math.min(value, this.getMaxOvercharge(stack)));
    }

    public int getMaxOvercharge(class_1799 stack) {
        return ConfigEntries.maxOvercharge;
    }

    public boolean method_7878(class_1799 staff, class_1799 stack) {
        if (this.rawInfos != null) {
            return this.rawInfos.repair.get().method_8093(stack);
        }
        return super.method_7878(staff, stack);
    }

    public int method_7837() {
        if (this.rawInfos != null) {
            return this.rawInfos.enchantability;
        }
        return super.method_7837();
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173 && this.pierce > 0) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (ItemHelper.hasEnchant(ModEnchants.BONK, stack)) {
                builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)(this.getAttackDamage(stack) - 1.0f), class_1322.class_1323.field_6328));
                builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", -3.0, class_1322.class_1323.field_6328));
            }
            builder.put((Object)ModAttributes.STAFF_DAMAGE, (Object)new class_1322(ModAttributes.STAFF_DAMAGE.getUUID(), "Weapon modifier", (double)this.getAttackDamage(stack), class_1322.class_1323.field_6328));
            builder.put((Object)ModAttributes.STAFF_PIERCE, (Object)new class_1322(ModAttributes.STAFF_PIERCE.getUUID(), "Weapon modifier", (double)this.getPierce(stack), class_1322.class_1323.field_6328));
            builder.put((Object)ModAttributes.STAFF_RANGE, (Object)new class_1322(ModAttributes.STAFF_RANGE.getUUID(), "Weapon modifier", (double)this.getAttackRange(stack), class_1322.class_1323.field_6328));
            return builder.build();
        }
        return super.method_7844(slot);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, world, tooltip, flag);
        if (stack.method_31573(ModTags.Items.FROSTSTEEL_ITEMS)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.froststeel_sword").method_27692(class_124.field_1075));
        }
        if (stack.method_31573(ModTags.Items.UTHERIUM_ITEMS)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.utheric_sword").method_27692(class_124.field_1061));
        }
        if (stack.method_31573(ModTags.Items.FORGOTTEN_ITEMS)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.forgotten_sword").method_27692(class_124.field_1060));
        }
        if (world != null && world.method_8608()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"sortilege.staff.cooldown", (Object[])new Object[]{Float.valueOf((float)this.getCooldown(stack, (class_1657)class_310.method_1551().field_1724) / 20.0f)}).method_27692(class_124.field_1080));
        }
        if (this.getXPCost(stack) > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"sortilege.staff.experience_cost", (Object[])new Object[]{this.getXPCost(stack)}).method_27692(class_124.field_1060));
            tooltip.add((class_2561)class_2561.method_43473());
        }
    }

    public int getOverchargeBarColor(class_1799 stack) {
        return Integer.decode(ConfigEntries.overchargeColor);
    }

    public int getOverchargeBarStep(class_1799 stack) {
        return Math.round((float)this.getOvercharge(stack) * 13.0f / (float)this.getMaxOvercharge(stack));
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        String id = class_7923.field_41178.method_10221((Object)other.method_7909()).toString();
        if (ConfigEntries.overchargeIngredients.containsKey(id) && this.getOvercharge(stack) < this.getMaxOvercharge(stack)) {
            other.method_7934(1);
            this.setOvercharge(stack, this.getOvercharge(stack) + ConfigEntries.overchargeIngredients.get(id).intValue());
            return true;
        }
        return false;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 staff = player.method_5998(hand);
        if (!player.method_7337() && !XPHelper.hasXP(player, this.getXPCost(staff)) && this.getOvercharge(staff) <= 0) {
            return super.method_7836(world, player, hand);
        }
        if (player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808).method_7909() instanceof class_1819 && player.method_5715()) {
            return super.method_7836(world, player, hand);
        }
        this.handSave = hand;
        player.method_6019(hand);
        return super.method_7836(world, player, hand);
    }

    public class_1799 method_7861(class_1799 staff, class_1937 world, class_1309 entity) {
        if (!(entity instanceof class_1657)) {
            return staff;
        }
        class_1657 player = (class_1657)entity;
        Set<ElementalStaffEnchantment> elements = this.getElements(staff);
        int cost = this.getXPCost(staff);
        float damage = this.getAttackDamage(staff);
        int range = this.getAttackRange(staff);
        int targetsLeft = this.getPierce(staff);
        if (!(cost <= 0 || player.method_7337() || this.getOvercharge(staff) > 0 && ConfigEntries.overchargePreventsExperience)) {
            if (!XPHelper.hasXP(player, cost)) {
                return staff;
            }
            player.method_7255(-cost);
        }
        if (this.handSave != null) {
            player.method_23667(this.handSave, true);
        }
        world.method_8396(player, player.method_24515(), class_3417.field_26982, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7357().method_7906(staff.method_7909(), this.getCooldown(staff, player));
        if (this.getOvercharge(staff) <= 0 || !ConfigEntries.overchargePreventsDurability) {
            staff.method_7956(1, (class_1309)player, e -> e.method_20236(this.handSave));
        }
        if (this.getOvercharge(staff) > 0) {
            this.setOvercharge(staff, this.getOvercharge(staff) - 1);
        }
        class_243 look = MathHelper.getLookVector((class_1309)player);
        ArrayList<String> targetsHit = new ArrayList<String>();
        float x = (float)player.method_23317();
        float y = (float)player.method_23318();
        float z = (float)player.method_23321();
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            if (this.rawInfos != null) {
                server.method_8503().method_3734().method_44252(player.method_5671().method_36321(class_2165.field_17395), this.rawInfos.on_shoot);
            }
        }
        List<float[]> colors = this.getBeamColors(staff, elements);
        int step = 5;
        for (int i = 1; i < range * step; ++i) {
            x = (float)(player.method_23317() + look.field_1352 * (double)i / (double)step);
            y = (float)(player.method_23318() + look.field_1351 * (double)i / (double)step + (double)player.method_18381(player.method_18376()) - 0.2);
            z = (float)(player.method_23321() + look.field_1350 * (double)i / (double)step);
            ModParticles.spawnWisps(world, x, y, z, 1, MathHelper.randi(colors));
            if (i * 2 % step != 0) continue;
            class_2338 pos = new class_2338((int)Math.round((double)x - 0.5), (int)Math.round((double)y - 0.5), (int)Math.round((double)z - 0.5));
            List entities = player.method_37908().method_8335((class_1297)player, new class_238(pos).method_1014(0.1));
            if (world.method_8320(pos).method_51367()) {
                if (!ConfigEntries.staffsPierceBlocks) break;
                --targetsLeft;
            }
            if (targetsLeft <= 0) break;
            for (int index = 0; !entities.isEmpty() && entities.size() > index && targetsLeft > 0; ++index) {
                class_6025 tameable;
                class_1309 target;
                Object e2 = entities.get(index);
                if (!(e2 instanceof class_1309) || targetsHit.contains((target = (class_1309)e2).method_5845()) || target instanceof class_6025 && (tameable = (class_6025)target).method_35057() == player) continue;
                this.triggerAttack(target, (class_1309)player, staff, elements, look, true, damage, targetsHit);
                --targetsLeft;
            }
        }
        if (elements.contains((Object)((ElementalStaffEnchantment)ModEnchants.BLAST))) {
            this.triggerBlastAttack((class_1309)player, staff, elements, look, damage, x, y, z, 2.0, targetsHit);
        }
        return staff;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (ItemHelper.hasEnchant(ModEnchants.BONK, stack)) {
            this.triggerAttack(target, attacker, stack, this.getElements(stack), MathHelper.getLookVector(attacker), true, this.getAttackDamage(stack), new ArrayList<String>());
        }
        return super.method_7873(stack, target, attacker);
    }

    public void triggerAttack(class_1309 target, class_1309 attacker, class_1799 stack, Set<ElementalStaffEnchantment> elements, class_243 direction, boolean propagate, float damage, List<String> targetsHit) {
        if (targetsHit.contains(target.method_5845())) {
            return;
        }
        class_1937 world = attacker.method_37908();
        float kinesis = ItemHelper.getEnchantLevel(ModEnchants.PUSH, stack) - ItemHelper.getEnchantLevel(ModEnchants.PULL, stack);
        float d = this.modifyDamageDealt(damage, stack, target, elements);
        if (d > 0.0f) {
            target.method_5643(attacker.method_48923().method_48815((class_1297)attacker, (class_1297)attacker), d);
        } else if (d < 0.0f) {
            target.method_6025(-d);
            ModParticles.spawnWisps(world, target.method_23317(), target.method_23318() + (double)(target.method_5751() / 2.0f), target.method_23321(), 10, new float[]{1.0f, 0.5f, 0.5f});
        }
        targetsHit.add(target.method_5845());
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            if (this.rawInfos != null) {
                server.method_8503().method_3734().method_44252(attacker.method_5671().method_9230(4).method_36321(class_2165.field_17395), this.rawInfos.on_hit_self);
                server.method_8503().method_3734().method_44252(target.method_5671().method_9230(4).method_36321(class_2165.field_17395), this.rawInfos.on_hit_target);
            }
        }
        if (kinesis != 0.0f) {
            target.method_18799(direction.method_1031(0.0, 0.07, 0.0).method_1029().method_1021((double)kinesis * 0.55));
        }
        for (ElementalStaffEnchantment element : elements) {
            int elementLevel = ItemHelper.getEnchantLevel(element, stack);
            element.triggerAttack(target, elementLevel);
            if (element != ModEnchants.BLAST || elementLevel <= 1 || !propagate) continue;
            this.triggerBlastAttack(attacker, stack, elements, direction, damage, target.method_23317(), target.method_23318() + (double)(target.method_5751() / 2.0f), target.method_23321(), 2.0, targetsHit);
        }
    }

    public void triggerBlastAttack(class_1309 attacker, class_1799 stack, Set<ElementalStaffEnchantment> elements, class_243 direction, float damage, double x, double y, double z, double radius, List<String> targetsHit) {
        if (attacker.method_37908().method_8608()) {
            attacker.method_37908().method_8437((class_1297)attacker, x, y, z, 1.0f, class_1937.class_7867.field_40888);
        }
        class_243 pos = new class_243(x, y, z);
        class_243 offset = new class_243(radius, radius, radius);
        for (class_1297 entity : attacker.method_37908().method_8335((class_1297)attacker, new class_238(pos.method_1020(offset), pos.method_1019(offset)))) {
            class_6025 tameable;
            class_1309 target;
            if (!(entity instanceof class_1309) || (target = (class_1309)entity) instanceof class_6025 && (tameable = (class_6025)target).method_35057() == attacker) continue;
            this.triggerAttack(target, attacker, stack, elements, direction, false, damage, targetsHit);
        }
    }

    public float modifyDamageDealt(float damage, class_1799 stack, class_1309 target, Set<ElementalStaffEnchantment> elements) {
        if (elements.contains((Object)((ElementalStaffEnchantment)ModEnchants.BLESSING))) {
            damage = target.method_5864().method_20210(ModTags.Entities.UNDEAD) ? (damage *= 1.0f + (float)ItemHelper.getEnchantLevel(ModEnchants.BLESSING, stack) * 0.5f) : (damage *= (float)ItemHelper.getEnchantLevel(ModEnchants.BLESSING, stack) * -0.75f);
        }
        if (target.method_5864().method_20210(ModTags.Entities.UNDERGARDEN_ENTITIES) && stack.method_31573(ModTags.Items.FORGOTTEN_ITEMS)) {
            damage *= 1.5f;
        }
        if (target.method_5864().method_20210(ModTags.Entities.ROTSPAWN) && stack.method_31573(ModTags.Items.UTHERIUM_ITEMS)) {
            damage *= 1.5f;
        }
        return damage;
    }

    public int method_7881(class_1799 stack) {
        return this.charge;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public boolean shouldRender(class_1799 stack) {
        return this.method_7801(stack) && !stack.method_31573(ModTags.Items.NO_DYE_OVERLAY_STAFFS);
    }

    @Override
    public void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22905(1.005f, 1.005f, 1.005f);
        matrices.method_22904(0.0, 0.995, 0.4975);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        MockItemRenderer.renderTintedItem(matrices, vertexConsumers, light, COLOR_OVERLAY, this.method_7800(stack));
    }
}

