/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.item.custom;

import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.item.ModItems;
import net.lyof.sortilege.item.custom.rendering.AddedRenderItem;
import net.lyof.sortilege.item.custom.rendering.MockItemRenderer;
import net.lyof.sortilege.particle.ModParticles;
import net.lyof.sortilege.setup.ModPackets;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5151;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

public class LapisShieldItem
extends class_1792
implements class_5151,
AddedRenderItem {
    private static final String COOLDOWN_NBT = "sortilege_LastUse";
    private static final class_2960 SHIELD_GLOW_LAYER = Sortilege.makeID("textures/models/lapis_shield_glow_layer.png");

    public LapisShieldItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1304 method_7685() {
        return class_1304.field_6171;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(class_1802.field_8759) || super.method_7878(stack, ingredient);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.modifiers.offhand").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.sortilege.lapis_shield.desc", (Object[])new Object[]{Float.valueOf((float)ConfigEntries.lapisShieldCooldown / 20.0f)}).method_27692(class_124.field_1080));
    }

    public static void addCooldown(class_1799 stack, int time) {
        stack.method_7948().method_10569(COOLDOWN_NBT, time);
    }

    public static void removeCooldown(class_1799 stack) {
        stack.method_7948().method_10551(COOLDOWN_NBT);
    }

    public static int getCooldownEnd(class_1799 stack) {
        return stack.method_7948().method_10550(COOLDOWN_NBT) + ConfigEntries.lapisShieldCooldown;
    }

    public static boolean isOnCooldown(class_1799 stack) {
        return stack.method_7948().method_10545(COOLDOWN_NBT);
    }

    public static void onSuccessfulUse(class_1799 stack, class_1309 entity, float amount) {
        if (!entity.method_37908().method_8608()) {
            LapisShieldItem.addCooldown(stack, entity.field_6012);
        }
        LapisShieldItem.sendCooldownUpdate(entity, entity.field_6012);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            player.method_7357().method_7906(ModItems.LAPIS_SHIELD, ConfigEntries.lapisShieldCooldown);
        }
        ModParticles.spawnWisps(entity.method_37908(), entity.method_23317(), entity.method_23318() + (double)(entity.method_18381(entity.method_18376()) / 2.0f), entity.method_23321(), 16, new float[]{0.3f, 0.3f, 1.0f});
        if (amount >= 3.0f) {
            stack.method_7956((int)amount / 2, entity, e -> e.method_20236(class_1268.field_5810));
            if (stack.method_7960()) {
                entity.method_5783(class_3417.field_15239, 0.8f, 0.8f + entity.method_37908().field_9229.method_43057() * 0.4f);
            }
        }
    }

    public static void sendCooldownUpdate(class_1309 entity, int cooldown) {
        if (!entity.method_37908().method_8608()) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(entity.method_5628());
            buf.writeInt(cooldown);
            for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)entity.method_37908()), (class_2338)entity.method_24515())) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.LAPIS_SHIELD_COOLDOWN, (class_2540)buf);
            }
        }
    }

    @Override
    public boolean shouldRender(class_1799 stack) {
        return !LapisShieldItem.isOnCooldown(stack);
    }

    @Override
    public void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22905(1.005f, 1.005f, 1.005f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_46416(-0.375f, -0.25f, -0.125f);
        MockItemRenderer.renderItem(matrices, vertexConsumers, -1, SHIELD_GLOW_LAYER);
    }
}

