/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final ResourceLocation ALT_FONT = new ResourceLocation("minecraft:alt");
    public static final ResourceLocation ILLAGER_ALT_FONT = new ResourceLocation("minecraft:illageralt");

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float width, float height, float scale) {
        RenderUtils.renderTextureFromCenter(matrix, centerX, centerY, 0.0f, 0.0f, width, height, width, height, scale);
    }

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float texOffX, float texOffY, float texWidth, float texHeight, float width, float height, float scale) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        matrix.m_85836_();
        matrix.m_252880_(centerX, centerY, 0.0f);
        matrix.m_85841_(scale, scale, scale);
        Matrix4f m = matrix.m_85850_().m_252922_();
        float u1 = texOffX / texWidth;
        float u2 = (texOffX + width) / texWidth;
        float v1 = texOffY / texHeight;
        float v2 = (texOffY + height) / texHeight;
        float w2 = width / 2.0f;
        float h2 = height / 2.0f;
        builder.m_252986_(m, -w2, h2, 0.0f).m_7421_(u1, v2).m_5752_();
        builder.m_252986_(m, w2, h2, 0.0f).m_7421_(u2, v2).m_5752_();
        builder.m_252986_(m, w2, -h2, 0.0f).m_7421_(u2, v1).m_5752_();
        builder.m_252986_(m, -w2, -h2, 0.0f).m_7421_(u1, v1).m_5752_();
        matrix.m_85849_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static int lerpColor(int colorStart, int colorEnd, float t) {
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        int aStart = colorStart >> 24 & 0xFF;
        int rStart = colorStart >> 16 & 0xFF;
        int gStart = colorStart >> 8 & 0xFF;
        int bStart = colorStart & 0xFF;
        int aEnd = colorEnd >> 24 & 0xFF;
        int rEnd = colorEnd >> 16 & 0xFF;
        int gEnd = colorEnd >> 8 & 0xFF;
        int bEnd = colorEnd & 0xFF;
        int a = (int)((float)aStart + t * (float)(aEnd - aStart));
        int r = (int)((float)rStart + t * (float)(rEnd - rStart));
        int g = (int)((float)gStart + t * (float)(gEnd - gStart));
        int b = (int)((float)bStart + t * (float)(bEnd - bStart));
        int color = a << 24 | r << 16 | g << 8 | b;
        return color;
    }

    public static MutableComponent illageriate(MutableComponent input, double percentage, long seed) {
        return RenderUtils.stylize(input, percentage, Style.f_131099_.m_131150_(ILLAGER_ALT_FONT), seed);
    }

    public static MutableComponent galactizate(MutableComponent input, double percentage, long seed) {
        return RenderUtils.stylize(input, percentage, Style.f_131099_.m_131150_(ALT_FONT), seed);
    }

    public static MutableComponent obfuscate(MutableComponent input, double percentage, long seed) {
        return RenderUtils.stylize(input, percentage, Style.f_131099_.m_178524_(Boolean.valueOf(true)).m_131140_(ChatFormatting.DARK_RED), seed);
    }

    public static MutableComponent stylize(MutableComponent input, double percentage, Style style, long seed) {
        RandomSource random = RandomSource.m_216335_((long)seed);
        String text = input.getString();
        int length = text.length();
        Set indices = IntStream.generate(() -> random.m_188503_(length)).distinct().limit((int)((double)length * percentage)).boxed().collect(Collectors.toSet());
        return IntStream.range(0, length).mapToObj(index -> {
            MutableComponent component = Component.m_237113_((String)String.valueOf(text.charAt(index))).m_6270_(input.m_7383_());
            if (indices.contains(index)) {
                component.m_6270_(style.m_131146_(component.m_7383_()));
            }
            return component;
        }).collect(Component::m_237119_, MutableComponent::m_7220_, MutableComponent::m_7220_);
    }
}

