/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.EndRemasteredCompat;
import einstein.subtle_effects.data.MobSkullShaderData;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.GameRendererAccessor;
import einstein.subtle_effects.mixin.client.block.AbstractCauldronBlockAccessor;
import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final int BREATH_DELAY = 60;
    public static final int SNORE_DELAY = 10;
    public static final int MAX_Z_COUNT = 3;
    public static final int PARTICLE_LIGHT_COLOR = 240;
    public static final DustParticleOptions GLOWSTONE_DUST_PARTICLES = new DustParticleOptions(Vec3.m_82501_((int)16759902).m_252839_(), 1.0f);
    public static final ResourceLocation COLORLESS_RAIN_TEXTURE = SubtleEffects.loc("textures/environment/colorless_rain.png");
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation VANILLA_EYE = new ResourceLocation("ender_eye");
    private static final String UUID = "d71e4b41-9315-499f-a934-ca925421fb38";

    public static void playClientSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null && level.f_46443_) {
            level.m_6269_((Player)minecraft.f_91074_, entity, sound, source, volume, pitch);
        }
    }

    public static void playClientSound(BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null && level.f_46443_) {
            level.m_6263_((Player)minecraft.f_91074_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), sound, source, volume, pitch);
        }
    }

    public static boolean isSolidOrNotEmpty(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60804_((BlockGetter)level, pos) || !level.m_6425_(pos).m_76178_();
    }

    public static void applyHelmetShader(ItemStack stack, CameraType cameraType) {
        if (!cameraType.m_90612_()) {
            return;
        }
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        for (MobSkullShaderData shaderData : MobSkullShaderReloadListener.MOB_SKULL_SHADERS.values()) {
            if (!shaderData.stackHolder().matches(stack)) continue;
            Util.loadShaderEffect(shaderData.shaderId(), gameRenderer);
            return;
        }
        gameRenderer.m_109086_();
    }

    private static void loadShaderEffect(ResourceLocation shaderId, GameRenderer gameRenderer) {
        PostChain effect = gameRenderer.m_109149_();
        if (effect == null || !effect.m_110022_().equals(shaderId.toString())) {
            ((GameRendererAccessor)gameRenderer).loadShaderEffect(shaderId);
        }
    }

    public static void setColorFromHex(Particle particle, int hexColor) {
        particle.m_107253_((float)(hexColor >> 16) / 255.0f, (float)(hexColor >> 8) / 255.0f, (float)hexColor / 255.0f);
    }

    public static boolean isChunkLoaded(Level level, double blockX, double blockZ) {
        return level.m_7726_().m_5563_(SectionPos.m_235865_((double)blockX), SectionPos.m_235865_((double)blockZ));
    }

    public static double getCauldronFillHeight(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock block2 = (AbstractCauldronBlock)block;
            return ((AbstractCauldronBlockAccessor)block2).getFillHeight(state);
        }
        return 0.0;
    }

    public static Fluid getCauldronFluid(BlockState state) {
        if (state.m_60713_(Blocks.f_152477_)) {
            return Fluids.f_76195_;
        }
        if (state.m_60713_(Blocks.f_152476_)) {
            return Fluids.f_76193_;
        }
        return Fluids.f_76191_;
    }

    @Nullable
    public static ParticleOptions getParticleForFluid(Fluid fluid) {
        if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
            return new SplashDropletParticleOptions(ModParticles.WATER_SPLASH_DROPLET.get(), 1.0f);
        }
        if (fluid.m_6212_((Fluid)Fluids.f_76195_)) {
            return new SplashDropletParticleOptions(ModParticles.LAVA_SPLASH_DROPLET.get(), 1.0f);
        }
        return null;
    }

    public static ValidatedColor.ColorHolder getEyeColorHolder(Level level, BlockPos pos) {
        ValidatedColor.ColorHolder color;
        if (CompatHelper.IS_END_REMASTERED_LOADED.get().booleanValue() && (color = EndRemasteredCompat.getEyeColor(level, pos)) != null) {
            return color;
        }
        ValidatedColor.ColorHolder vanillaColor = (ValidatedColor.ColorHolder)ModConfigs.BLOCKS.eyeColors.get((Object)VANILLA_EYE);
        if (vanillaColor != null) {
            return vanillaColor;
        }
        return Util.toColorHolder(0x7ABAAB);
    }

    public static ValidatedColor.ColorHolder toColorHolder(int color) {
        return new ValidatedColor.ColorHolder(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255, false);
    }

    public static float randomizeColor(RandomSource random, float color, float multiplier) {
        return (random.m_188501_() * 0.2f + 0.8f) * color * multiplier;
    }

    public static void setRandomizedColor(Particle particle, RandomSource random, float r, float g, float b) {
        float multiplier = random.m_188501_() * 0.4f + 0.6f;
        particle.m_107253_(Util.randomizeColor(random, r, multiplier), Util.randomizeColor(random, g, multiplier), Util.randomizeColor(random, b, multiplier));
    }

    @Nullable
    public static ParticleOptions getCauldronParticle(BlockState state) {
        Fluid fluid = Util.getCauldronFluid(state);
        if (!fluid.m_6212_(Fluids.f_76191_)) {
            return Util.getParticleForFluid(fluid);
        }
        if (state.m_60713_(Blocks.f_152478_)) {
            return (ParticleOptions)ModParticles.SNOW.get();
        }
        return null;
    }

    public static float getPartialTicks() {
        return Minecraft.m_91087_().m_91296_();
    }

    public static boolean isMincraftEinstein(AbstractClientPlayer player) {
        return player.m_20149_().equals(UUID);
    }

    public static String getOrdinal(long number) {
        return number + (number == 1L ? "st" : (number == 2L ? "nd" : (number == 3L ? "rd" : "th")));
    }

    public static boolean isRainingAt(Level level, BlockPos pos) {
        if (level.m_46471_() && level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_()) {
            return ((Biome)level.m_204166_(pos).m_203334_()).m_264600_(pos) == Biome.Precipitation.RAIN;
        }
        return false;
    }
}

