/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity;

import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.SoulFiredCompat;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityFireTicker
extends EntityTicker<Entity> {
    private final float bbWidth;
    private final float bbHeight;
    private final boolean isBlaze;

    public EntityFireTicker(Entity entity) {
        super(entity);
        this.isBlaze = this.entity.m_6095_().equals(EntityType.f_20551_);
        this.bbWidth = entity.m_20205_();
        this.bbHeight = entity.m_20206_();
    }

    @Override
    public void entityTick() {
        if (this.entity.m_6051_() || this.isBlaze) {
            if (this.random.m_188503_(90) == 0 && ModConfigs.ENTITIES.burning.sounds) {
                Util.playClientSound(this.entity, SoundEvents.f_11937_, this.entity.m_5720_(), 0.3f, 1.0f);
            }
            if (this.bbWidth <= 4.0f && this.bbHeight <= 4.0f) {
                if (ModConfigs.ENTITIES.burning.smoke.isEnabled() && !this.isBlaze) {
                    this.level.m_7106_(ModConfigs.ENTITIES.burning.smoke.getParticle().get(), this.entity.m_20208_(1.0), this.entity.m_20187_(), this.entity.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                if (ModConfigs.ENTITIES.burning.sparks) {
                    for (int i = 0; i < 2; ++i) {
                        this.level.m_7106_((ParticleOptions)(this.isBlaze ? SparkParticle.create(SparkType.SHORT_LIFE, this.random, SparkParticle.BLAZE_COLORS) : this.getParticleForFireType((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, this.random), (ParticleOptions)SparkParticle.createSoul(SparkType.SHORT_LIFE, this.random))), this.entity.m_20208_(1.0), this.entity.m_20187_(), this.entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(this.random, 0.03), MathUtil.nextNonAbsDouble(this.random, 0.05), MathUtil.nextNonAbsDouble(this.random, 0.03));
                    }
                }
                if (this.bbWidth < 2.0f && this.bbHeight < 2.0f && !this.random.m_188499_()) {
                    return;
                }
                if (ModConfigs.ENTITIES.burning.flames) {
                    this.level.m_7106_(this.getParticleForFireType((ParticleOptions)ParticleTypes.f_123744_, (ParticleOptions)ParticleTypes.f_123745_), this.entity.m_20208_(1.0), this.entity.m_20187_(), this.entity.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private ParticleOptions getParticleForFireType(ParticleOptions normal, ParticleOptions soul) {
        return CompatHelper.IS_SOUL_FIRED_LOADED.get() != false && SoulFiredCompat.isOnSoulFire(this.entity) ? soul : normal;
    }
}

