/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.option;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public record SplashParticleOptions(ParticleType<SplashParticleOptions> type, float xScale, float yScale, boolean hasRipple) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<SplashParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<SplashParticleOptions>(){

        public SplashParticleOptions fromCommand(ParticleType<SplashParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float xScale = reader.readFloat();
            reader.expect(' ');
            float yScale = reader.readFloat();
            reader.expect(' ');
            boolean hasRipple = reader.readBoolean();
            return new SplashParticleOptions(type, xScale, yScale, hasRipple);
        }

        public SplashParticleOptions fromNetwork(ParticleType<SplashParticleOptions> type, FriendlyByteBuf buf) {
            return new SplashParticleOptions(type, buf.readFloat(), buf.readFloat(), buf.readBoolean());
        }
    };

    public static Codec<SplashParticleOptions> codec(ParticleType<SplashParticleOptions> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("xScale").forGetter(SplashParticleOptions::xScale), (App)Codec.FLOAT.fieldOf("yScale").forGetter(SplashParticleOptions::yScale), (App)Codec.BOOL.fieldOf("hasRipple").forGetter(SplashParticleOptions::hasRipple)).apply((Applicative)instance, (xScale, yScale, hasRipple) -> new SplashParticleOptions(type, xScale.floatValue(), yScale.floatValue(), (boolean)hasRipple)));
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.xScale);
        buf.writeFloat(this.yScale);
        buf.writeBoolean(this.hasRipple);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s %s %s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.xScale), Float.valueOf(this.yScale), this.hasRipple);
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }
}

