/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.option;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import einstein.subtle_effects.init.ModParticles;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;

public record SheepFluffParticleOptions(DyeColor color, int sheepId, boolean isJeb) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<SheepFluffParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<SheepFluffParticleOptions>(){

        public SheepFluffParticleOptions fromCommand(ParticleType<SheepFluffParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            reader.expect(' ');
            int sheepId = reader.readInt();
            reader.expect(' ');
            boolean isJeb = reader.readBoolean();
            return new SheepFluffParticleOptions(DyeColor.m_41053_((int)color), sheepId, isJeb);
        }

        public SheepFluffParticleOptions fromNetwork(ParticleType<SheepFluffParticleOptions> type, FriendlyByteBuf buf) {
            return new SheepFluffParticleOptions(DyeColor.m_41053_((int)buf.readByte()), buf.readInt(), buf.readBoolean());
        }
    };
    public static Codec<SheepFluffParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DyeColor.f_262211_.fieldOf("color").forGetter(SheepFluffParticleOptions::color), (App)Codec.INT.fieldOf("sheepId").forGetter(SheepFluffParticleOptions::sheepId), (App)Codec.BOOL.fieldOf("isJeb").forGetter(SheepFluffParticleOptions::isJeb)).apply((Applicative)instance, SheepFluffParticleOptions::new));

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeByte(this.color.m_41060_());
        buf.writeInt(this.sheepId);
        buf.writeBoolean(this.isJeb);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s %s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.color, this.sheepId);
    }

    public ParticleType<?> m_6012_() {
        return ModParticles.SHEEP_FLUFF.get();
    }
}

