/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.emitter;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class SplashEmitter
extends NoRenderParticle {
    @Nullable
    private final Entity entity;
    private final float velocity;
    private final float absVelocity;
    private final boolean isLava;
    private final TagKey<Fluid> fluidTag;
    private final float widthModifier;
    private final float heightModifier;
    private final float xScale;
    private final float yScale;
    private final ParticleType<SplashParticleOptions> splashParticle;
    private final ParticleType<SplashDropletParticleOptions> dropletParticle;
    private final BlockPos.MutableBlockPos pos;
    private boolean firstSplash = true;
    private boolean secondSplash = true;

    protected SplashEmitter(ClientLevel level, double x, double y, double z, TagKey<Fluid> fluidTag, ParticleType<SplashParticleOptions> splashParticle, ParticleType<SplashDropletParticleOptions> dropletParticle, boolean isLava, SplashEmitterParticleOptions options) {
        super(level, x, y, z);
        this.fluidTag = fluidTag;
        this.isLava = isLava;
        this.splashParticle = splashParticle;
        this.dropletParticle = dropletParticle;
        this.f_107225_ = 8;
        this.pos = BlockPos.m_274561_((double)x, (double)y, (double)z).m_122032_();
        this.velocity = options.velocity();
        this.absVelocity = Mth.m_14154_((float)this.velocity);
        this.widthModifier = options.widthModifier();
        this.heightModifier = options.heightModifier();
        this.xScale = this.widthModifier + 0.5f;
        this.yScale = this.absVelocity * this.heightModifier * this.widthModifier * 2.0f;
        if (options.entityId() > -1) {
            this.entity = level.m_6815_(options.entityId());
            return;
        }
        this.entity = null;
    }

    public static SplashEmitterParticleOptions createForEntity(Entity entity, ParticleType<SplashEmitterParticleOptions> splashParticle, double yVelocity) {
        float entityWidth = entity.m_20205_();
        float entityHeight = entity.m_20206_();
        Entity passenger = entity.m_146895_();
        if (passenger != null) {
            entityWidth = Math.max(entityWidth, passenger.m_20205_());
            entityHeight += passenger.m_20206_() / 2.0f;
        }
        return new SplashEmitterParticleOptions(splashParticle, entityWidth, entityHeight, (float)yVelocity, entity.m_19879_());
    }

    public void m_5989_() {
        boolean isInFluid;
        if (this.f_107220_) {
            return;
        }
        super.m_5989_();
        this.pos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        boolean bl = isInFluid = this.f_107208_.m_6425_((BlockPos)this.pos).m_205070_(this.fluidTag) || Util.getCauldronFluid(this.f_107208_.m_8055_((BlockPos)this.pos)).m_205067_(this.fluidTag);
        if (!isInFluid || this.f_107218_) {
            this.m_107274_();
            return;
        }
        if (this.firstSplash) {
            this.spawnSplashParticles(this.xScale, this.yScale, this.yScale * 0.5f / this.widthModifier * 0.3f, this.xScale);
            this.firstSplash = false;
            if (ModConfigs.ENTITIES.splashes.splashBubbles && this.entity != null && this.f_107208_.m_6425_(this.pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
                int i = 0;
                while ((float)i < 8.0f * (this.widthModifier * 5.0f)) {
                    int xSign = MathUtil.nextSign(this.f_107223_);
                    int zSign = MathUtil.nextSign(this.f_107223_);
                    this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123774_, this.f_107212_ + MathUtil.nextDouble(this.f_107223_, 0.1) * (double)xSign, this.f_107223_.m_188503_(3) == 0 ? Mth.m_216263_((RandomSource)this.f_107223_, (double)(this.entity.m_20186_() + (double)this.heightModifier), (double)this.f_107213_) : this.entity.m_20187_(), this.f_107214_ + MathUtil.nextDouble(this.f_107223_, 0.1) * (double)zSign, MathUtil.nextNonAbsDouble(this.f_107223_, this.xScale), (double)(-this.absVelocity * 2.0f) * Mth.m_216263_((RandomSource)this.f_107223_, (double)0.5, (double)2.0), MathUtil.nextNonAbsDouble(this.f_107223_, this.xScale));
                    ++i;
                }
            }
            if (!ModConfigs.ENTITIES.splashes.secondarySplash || this.velocity > -((Float)ModConfigs.ENTITIES.splashes.secondarySplashVelocityThreshold.get()).floatValue()) {
                this.m_107274_();
            }
            return;
        }
        if (this.f_107224_ >= this.f_107225_ && this.secondSplash) {
            this.spawnSplashParticles(this.xScale / 2.0f, this.yScale * 1.5f, this.yScale * 0.85f / this.widthModifier * 0.3f, this.xScale * 0.8f);
            this.secondSplash = false;
        }
    }

    private void spawnSplashParticles(float xScale, float yScale, float dropletYSpeed, float dropletXSpeed) {
        this.f_107208_.m_6485_((ParticleOptions)new SplashParticleOptions(this.splashParticle, xScale, yScale, this.hasRipple()), true, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
        if (!ModConfigs.ENTITIES.splashes.splashDroplets) {
            return;
        }
        SplashDropletParticleOptions dropletOptions = new SplashDropletParticleOptions(this.dropletParticle, Math.min(this.xScale, 2.0f), this.isLava ? 1.0f : ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue());
        int i = 0;
        while ((float)i < 4.0f * this.widthModifier) {
            this.f_107208_.m_7106_((ParticleOptions)dropletOptions, this.f_107212_ + MathUtil.nextNonAbsDouble(this.f_107223_, xScale), this.f_107213_ + MathUtil.nextDouble(this.f_107223_, 0.6) * (double)yScale, this.f_107214_ + MathUtil.nextNonAbsDouble(this.f_107223_, xScale), 0.0, (double)dropletYSpeed, 0.0);
            ++i;
        }
        i = 0;
        while ((float)i < 8.0f * this.widthModifier) {
            int xSign = MathUtil.nextSign(this.f_107223_);
            int zSign = MathUtil.nextSign(this.f_107223_);
            this.f_107208_.m_7106_((ParticleOptions)dropletOptions, this.f_107212_ + MathUtil.nextDouble(this.f_107223_, xScale) * (double)xSign, this.f_107213_ + MathUtil.nextDouble(this.f_107223_, 0.6) * (double)yScale, this.f_107214_ + MathUtil.nextDouble(this.f_107223_, xScale) * (double)zSign, Mth.m_216263_((RandomSource)this.f_107223_, (double)0.01, (double)0.1) * (double)dropletXSpeed * (double)xSign, (double)dropletYSpeed, Mth.m_216263_((RandomSource)this.f_107223_, (double)0.01, (double)0.1) * (double)dropletXSpeed * (double)zSign);
            ++i;
        }
    }

    private boolean hasRipple() {
        if (ModConfigs.ENTITIES.splashes.splashRipples) {
            if (!ModConfigs.ENTITIES.splashes.lavaSplashRipples && this.isLava) {
                return false;
            }
            return this.firstSplash || this.secondSplash && ModConfigs.ENTITIES.splashes.secondarySplashRipples;
        }
        return false;
    }

    public record LavaProvider() implements ParticleProvider<SplashEmitterParticleOptions>
    {
        public Particle createParticle(SplashEmitterParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashEmitter(level, x, y, z, (TagKey<Fluid>)FluidTags.f_13132_, ModParticles.LAVA_SPLASH.get(), ModParticles.LAVA_SPLASH_DROPLET.get(), true, options);
        }
    }

    public record Provider() implements ParticleProvider<SplashEmitterParticleOptions>
    {
        public Particle createParticle(SplashEmitterParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashEmitter(level, x, y, z, (TagKey<Fluid>)FluidTags.f_13131_, ModParticles.WATER_SPLASH.get(), ModParticles.WATER_SPLASH_DROPLET.get(), false, options);
        }
    }
}

