/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.emitter;

import einstein.subtle_effects.configs.entities.HumanoidConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.ColorAndIntegerParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class PotionEmitter
extends NoRenderParticle {
    private final int color;
    private final int entityId;
    @Nullable
    private final Entity entity;

    protected PotionEmitter(ClientLevel level, double x, double y, double z, int color, int entityId) {
        super(level, x, y, z);
        this.color = color;
        this.entityId = entityId;
        Util.setColorFromHex((Particle)this, color);
        this.entity = level.m_6815_(entityId);
        this.f_107225_ = 1;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.entity != null) {
            this.f_107212_ = this.entity.m_20185_();
            this.f_107213_ = this.entity.m_20186_();
            this.f_107214_ = this.entity.m_20189_();
        }
        if (ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.BOTH || ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.RINGS_ONLY) {
            for (int i = 0; i < 3; ++i) {
                this.f_107208_.m_7106_((ParticleOptions)new ColorAndIntegerParticleOptions(ModParticles.POTION_RING.get(), this.color, this.entityId), this.f_107212_, this.f_107213_ - 0.1 + 0.4 * (double)i, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
        if (ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.BOTH || ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.DOTS_ONLY) {
            float scale = ((Float)ModConfigs.ENTITIES.humanoids.potionRingsScale.get()).floatValue();
            for (int i = 0; i < 20; ++i) {
                this.f_107208_.m_7106_((ParticleOptions)new ColorAndIntegerParticleOptions(ModParticles.POTION_DOT.get(), this.color, this.entityId), this.f_107212_ + MathUtil.nextNonAbsDouble(this.f_107223_, 0.75 * (double)scale), this.f_107213_ + this.f_107223_.m_188500_() - 0.5, this.f_107214_ + MathUtil.nextNonAbsDouble(this.f_107223_, 0.75 * (double)scale), 0.0, 0.0, 0.0);
            }
        }
    }

    public record Provider() implements ParticleProvider<ColorAndIntegerParticleOptions>
    {
        public Particle createParticle(ColorAndIntegerParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new PotionEmitter(level, x, y, z, options.color(), options.integer());
        }
    }
}

