/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.GeyserSpoutParticleOptions;
import einstein.subtle_effects.ticking.tickers.geyser.GeyserTicker;
import einstein.subtle_effects.ticking.tickers.geyser.GeyserType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;

public class GeyserSpoutParticle
extends FlatPlaneParticle {
    private static final int FADE_TIME = 60;
    private static final float START_ALPHA = 1.0f;
    private final int geyserLifeTime;
    private final GeyserType type;
    private final BlockPos pos;

    protected GeyserSpoutParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, GeyserSpoutParticleOptions options) {
        super(level, x, y, z);
        this.pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        this.geyserLifeTime = options.lifeTime();
        this.type = GeyserType.values()[options.type()];
        this.rotation.rotateY((float)(90 * this.f_107223_.m_188503_(3)) * ((float)Math.PI / 180)).rotateX(1.5707964f);
        this.f_107225_ = this.geyserLifeTime + 60;
        this.f_107219_ = false;
        this.renderBackFace = false;
        this.f_107230_ = 1.0f;
        this.f_107663_ = 0.5f;
        this.m_107250_(1.5f, 0.1f);
        this.m_108335_(sprites);
    }

    public void m_5989_() {
        if (!GeyserTicker.isSpawnableBlock(this.type, (Level)this.f_107208_, this.pos.m_7495_(), SupportType.RIGID)) {
            this.m_107274_();
            return;
        }
        if (this.f_107224_ >= this.geyserLifeTime) {
            this.f_107230_ -= 0.016666668f;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<GeyserSpoutParticleOptions>
    {
        public Particle createParticle(GeyserSpoutParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GeyserSpoutParticle(level, x, y, z, this.sprites, options);
        }
    }
}

