/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class FlatPlaneParticle
extends TextureSheetParticle {
    protected Quaternionf rotation = new Quaternionf();
    protected boolean renderBackFace = true;

    protected FlatPlaneParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    protected FlatPlaneParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTicks) {
        Quaternionf rotation = new Quaternionf((Quaternionfc)this.rotation);
        if (this.f_107231_ != 0.0f) {
            rotation.rotateZ(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
        }
        this.renderQuad(consumer, camera, partialTicks, rotation);
    }

    protected void renderQuad(VertexConsumer consumer, Camera camera, float partialTicks, Quaternionf rotation) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, false);
        if (this.renderBackFace) {
            this.renderQuad(consumer, rotation, partialTicks, x, y, z, true);
        }
    }

    protected void renderQuad(VertexConsumer consumer, Quaternionf rotation, float partialTicks, float x, float y, float z, boolean renderInverted) {
        float quadSize = this.m_5902_(partialTicks);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int packedLight = this.m_6355_(partialTicks);
        int i = renderInverted ? 1 : -1;
        int i2 = renderInverted ? -1 : 1;
        this.renderVertex(consumer, rotation, x, y, z, i, -1.0f, quadSize, u1, v1, packedLight);
        this.renderVertex(consumer, rotation, x, y, z, i, 1.0f, quadSize, u1, v0, packedLight);
        this.renderVertex(consumer, rotation, x, y, z, i2, 1.0f, quadSize, u0, v0, packedLight);
        this.renderVertex(consumer, rotation, x, y, z, i2, -1.0f, quadSize, u0, v1, packedLight);
    }

    protected void renderVertex(VertexConsumer buffer, Quaternionf rotation, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)rotation).mul(quadSize).add(x, y, z);
        buffer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight).m_5752_();
    }
}

