/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.block;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateBaseMixin {
    @WrapOperation(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;use(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult use(Block block, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, Operation<InteractionResult> original) {
        if (level.f_46443_ && (ModConfigs.BLOCKS.cakeEatParticles || ModConfigs.BLOCKS.cakeEatSounds)) {
            Pair<IntegerProperty, Integer> bitesData = BlockStateBaseMixin.subtleEffects$getBitesData(state);
            boolean hadBites = bitesData != null;
            int oldBites = hadBites ? (Integer)state.m_61143_((Property)bitesData.getFirst()) : 0;
            InteractionResult result = (InteractionResult)original.call(new Object[]{block, state, level, pos, player, hand, hitResult});
            if (result == InteractionResult.SUCCESS) {
                BlockState newState = level.m_8055_(pos);
                int maxBites = 0;
                int bites = 0;
                if (hadBites) {
                    maxBites = (Integer)bitesData.getSecond();
                    bites = newState.m_61138_((Property)bitesData.getFirst()) ? (Integer)newState.m_61143_((Property)bitesData.getFirst()) : oldBites + 1;
                } else {
                    bitesData = BlockStateBaseMixin.subtleEffects$getBitesData(newState);
                    if (bitesData != null) {
                        bites = (Integer)newState.m_61143_((Property)bitesData.getFirst());
                        maxBites = (Integer)bitesData.getSecond();
                    }
                }
                if (bites > oldBites) {
                    ItemStack stack = block.m_7397_((BlockGetter)level, pos, state);
                    RandomSource random = player.m_217043_();
                    if (!stack.m_41619_() && ModConfigs.BLOCKS.cakeEatParticles) {
                        float partialTick = Util.getPartialTicks();
                        ItemParticleOption options = new ItemParticleOption(ParticleTypes.f_123752_, stack);
                        for (int i = 0; i < 16; ++i) {
                            ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)options, (LivingEntity)player, level, random, Vec3.f_82478_, partialTick);
                        }
                    }
                    if (ModConfigs.BLOCKS.cakeEatSounds) {
                        SoundSource soundSource = player.m_5720_();
                        if (bites == maxBites) {
                            Util.playClientSound((Entity)player, SoundEvents.f_12321_, soundSource, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                        }
                        if (!((IntegerProperty)bitesData.getFirst()).equals((Object)CompatHelper.FD_PIE_BITES)) {
                            Util.playClientSound((Entity)player, player.m_7866_(stack), soundSource, 0.5f + 0.5f * (float)random.m_188503_(2), (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
                        }
                    }
                }
            }
            return result;
        }
        return (InteractionResult)original.call(new Object[]{block, state, level, pos, player, hand, hitResult});
    }

    @Unique
    @Nullable
    private static Pair<IntegerProperty, Integer> subtleEffects$getBitesData(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61412_)) {
            return Pair.of((Object)BlockStateProperties.f_61412_, (Object)7);
        }
        IntegerProperty pieProperty = BlockStateBaseMixin.subtleEffects$findProperty(state, CompatHelper.FD_PIE_BITES);
        if (pieProperty != null) {
            return Pair.of((Object)pieProperty, (Object)4);
        }
        IntegerProperty twoTieredCakeProperty = BlockStateBaseMixin.subtleEffects$findProperty(state, CompatHelper.JMC_TWO_TIERED_CAKE_BITES);
        if (twoTieredCakeProperty != null) {
            return Pair.of((Object)twoTieredCakeProperty, (Object)11);
        }
        IntegerProperty threeTieredCakeProperty = BlockStateBaseMixin.subtleEffects$findProperty(state, CompatHelper.JMC_THREE_TIERED_CAKE_BITES);
        if (threeTieredCakeProperty != null) {
            return Pair.of((Object)threeTieredCakeProperty, (Object)16);
        }
        return null;
    }

    @Unique
    private static IntegerProperty subtleEffects$findProperty(BlockState state, IntegerProperty property1) {
        return state.m_61147_().stream().filter(property2 -> property2.equals((Object)property1)).findFirst().orElse(null);
    }
}

