/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.SparkType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.phys.Vec3;

public record SparkProviderData(List<BlockStateEntry> states, Optional<Options> options) {
    public static final Codec<SparkProviderData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_144637_((Codec)Codec.list(BlockStateEntry.CODEC)).fieldOf("states").forGetter(SparkProviderData::states), (App)Options.CODEC.optionalFieldOf("options").forGetter(SparkProviderData::options)).apply((Applicative)instance, SparkProviderData::new));

    public record BlockStateEntry(ResourceLocation id, boolean required, Map<String, String> properties) {
        public static final Codec<BlockStateEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(BlockStateEntry::id), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(BlockStateEntry::required), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties", Map.of()).forGetter(BlockStateEntry::properties)).apply((Applicative)instance, BlockStateEntry::new));
    }

    public record Options(PresetType preset, Optional<SparkType> sparkType, Optional<Box> box, Optional<IntProvider> count, Optional<Float> chance, Optional<Vec3> velocity, Optional<List<Integer>> colors) {
        public static final Codec<Integer> RGB_COLOR_CODEC = Codec.either((Codec)Codec.INT, (Codec)ExtraCodecs.f_252432_).xmap(either -> (Integer)either.map(i -> i, color -> FastColor.ARGB32.m_13660_((int)255, (int)Mth.m_14143_((float)(color.x() * 255.0f)), (int)Mth.m_14143_((float)(color.y() * 255.0f)), (int)Mth.m_14143_((float)(color.z() * 255.0f)))), Either::left);
        public static final Codec<Options> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PresetType.CODEC.fieldOf("preset").forGetter(Options::preset), (App)SparkType.CODEC.optionalFieldOf("spark").forGetter(Options::sparkType), (App)Box.CODEC.optionalFieldOf("box").forGetter(Options::box), (App)IntProvider.f_146531_.optionalFieldOf("count").forGetter(Options::count), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance").forGetter(Options::chance), (App)Vec3.f_231074_.optionalFieldOf("velocity").forGetter(Options::velocity), (App)Codec.either((Codec)Codec.list(RGB_COLOR_CODEC), (Codec)Codec.STRING).xmap(either -> (List)either.map(i -> i, string -> {
            if (string.equals("soul")) {
                return SparkParticle.SOUL_COLORS;
            }
            if (string.equals("default")) {
                return SparkParticle.DEFAULT_COLORS;
            }
            SubtleEffects.LOGGER.error("Spark color must be an integer array or string of either 'soul' or 'default'");
            return null;
        }), Either::left).optionalFieldOf("colors").forGetter(Options::colors)).apply((Applicative)instance, Options::new));
    }

    public static enum PresetType implements StringRepresentable
    {
        CUSTOM("custom"),
        CAMPFIRE("campfire"),
        FIRE("fire"),
        TORCH("torch"),
        WALL_TORCH("wall_torch"),
        CANDLE("candle"),
        LANTERN("lantern"),
        FURNACE("furnace");

        public static final Codec<PresetType> CODEC;
        private final String name;

        private PresetType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(PresetType::values);
        }
    }
}

