/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.data.MobSkullShaderData;
import einstein.subtle_effects.data.NamedReloadListener;
import einstein.subtle_effects.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class MobSkullShaderReloadListener
extends SimpleJsonResourceReloadListener
implements NamedReloadListener {
    public static final String DIRECTORY = "subtle_effects/mob_skull_shaders";
    public static final Map<ResourceLocation, MobSkullShaderData> MOB_SKULL_SHADERS = new HashMap<ResourceLocation, MobSkullShaderData>();

    public MobSkullShaderReloadListener() {
        super(Util.GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager manager, ProfilerFiller profiler) {
        MOB_SKULL_SHADERS.clear();
        resources.forEach((id, element) -> MobSkullShaderData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, element).resultOrPartial(error -> SubtleEffects.LOGGER.error("Failed to decode mob skull shader with ID {} - Error: {}", id, error)).ifPresent(shaderData -> MobSkullShaderReloadListener.load(manager, id, shaderData)));
    }

    private static void load(ResourceManager manager, ResourceLocation location, MobSkullShaderData shaderData) {
        Item item = shaderData.stackHolder().item();
        if (item.equals(Items.f_41852_)) {
            SubtleEffects.LOGGER.error("Item in Mob Skull Shader '{}' can not be air", (Object)location);
            return;
        }
        ResourceLocation shaderId = shaderData.shaderId();
        if (manager.m_213713_(shaderId).isEmpty()) {
            SubtleEffects.LOGGER.error("Could not find post shader with ID '{}' for Mob Skull Shader: '{}'", (Object)shaderId, (Object)location);
            return;
        }
        MOB_SKULL_SHADERS.put(location, shaderData);
    }

    @Override
    public ResourceLocation getId() {
        return SubtleEffects.loc("mob_skull_shaders");
    }
}

