/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;

public enum EntitySerializerType {
    BYTE,
    INT,
    LONG,
    FLOAT,
    STRING,
    BOOLEAN,
    COMPOUND_TAG,
    UUID,
    VECTOR3,
    QUATERNION;


    public EntityDataSerializer<?> getSerializer() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BYTE -> EntityDataSerializers.f_135027_;
            case INT -> EntityDataSerializers.f_135028_;
            case LONG -> EntityDataSerializers.f_244073_;
            case FLOAT -> EntityDataSerializers.f_135029_;
            case STRING -> EntityDataSerializers.f_135030_;
            case BOOLEAN -> EntityDataSerializers.f_135035_;
            case COMPOUND_TAG -> EntityDataSerializers.f_135042_;
            case VECTOR3 -> EntityDataSerializers.f_268676_;
            case QUATERNION -> EntityDataSerializers.f_268624_;
            case UUID -> EntityDataSerializers.f_135041_;
        };
    }

    public static <T> T castValue(Object value, @Nullable String castHint) {
        if (value instanceof Number) {
            Number num = (Number)value;
            if (castHint != null) {
                switch (castHint.toLowerCase()) {
                    case "byte": {
                        return (T)Byte.valueOf(num.byteValue());
                    }
                    case "int": {
                        return (T)Integer.valueOf(num.intValue());
                    }
                    case "float": {
                        return (T)Float.valueOf(num.floatValue());
                    }
                    case "long": {
                        return (T)Long.valueOf(num.longValue());
                    }
                }
            }
            double d = num.doubleValue();
            if (num instanceof Float) {
                return (T)Float.valueOf(num.floatValue());
            }
            if (num instanceof Long || d % 1.0 == 0.0 && d > 2.147483647E9 && d <= 9.223372036854776E18) {
                return (T)Long.valueOf(num.longValue());
            }
            if (num instanceof Integer || d % 1.0 == 0.0 && d >= -2.147483648E9 && d <= 2.147483647E9) {
                return (T)Integer.valueOf(num.intValue());
            }
            return (T)Float.valueOf(num.floatValue());
        }
        if (value instanceof UUID) {
            return (T)Optional.of(value);
        }
        if (value instanceof String) {
            return (T)value;
        }
        if (value instanceof Boolean) {
            return (T)value;
        }
        if (value instanceof CompoundTag) {
            return (T)value;
        }
        if (value instanceof Vector3f) {
            return (T)value;
        }
        if (value instanceof Vector3d) {
            Vector3d vec3 = (Vector3d)value;
            return (T)new Vector3f((float)vec3.x, (float)vec3.y, (float)vec3.z);
        }
        if (value instanceof Vector3i) {
            Vector3i vec3 = (Vector3i)value;
            return (T)new Vector3f((float)vec3.x, (float)vec3.y, (float)vec3.z);
        }
        if (value instanceof Vec3) {
            Vec3 vec3 = (Vec3)value;
            return (T)new Vector3f((float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_);
        }
        if (value instanceof Quaternionf) {
            return (T)value;
        }
        throw new IllegalArgumentException("Unsupported value type for casting: " + value.getClass());
    }

    public static EntitySerializerType fromObject(Object value) {
        if (value instanceof Byte) {
            return BYTE;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            double d = num.doubleValue();
            if (num instanceof Float) {
                return FLOAT;
            }
            if (num instanceof Long || d % 1.0 == 0.0 && d >= -9.223372036854776E18 && d <= 9.223372036854776E18 && d > 2.147483647E9) {
                return LONG;
            }
            if (num instanceof Integer || d % 1.0 == 0.0 && d >= -2.147483648E9 && d <= 2.147483647E9) {
                return INT;
            }
            return FLOAT;
        }
        if (value instanceof UUID) {
            return UUID;
        }
        if (value instanceof String) {
            return STRING;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof CompoundTag) {
            return COMPOUND_TAG;
        }
        if (value instanceof Vector3f) {
            return VECTOR3;
        }
        if (value instanceof Vector3d) {
            return VECTOR3;
        }
        if (value instanceof Vector3i) {
            return VECTOR3;
        }
        if (value instanceof Vec3) {
            return VECTOR3;
        }
        if (value instanceof Quaternionf) {
            return QUATERNION;
        }
        throw new IllegalArgumentException("Unsupported value type for serializer: " + value.getClass());
    }

    public static EntitySerializerType fromSerializer(EntityDataSerializer<?> serializer) {
        for (EntitySerializerType type : EntitySerializerType.values()) {
            if (type.getSerializer() != serializer) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown EntityDataSerializer: " + serializer);
    }
}

