/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.nonliving;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderEntityBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class KubeJSEnderEyeRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final EyeOfEnderEntityBuilder<T> builder;

    public KubeJSEnderEyeRenderer(EntityRendererProvider.Context renderManager, EyeOfEnderEntityBuilder<T> builder) {
        super(renderManager);
        this.builder = builder;
    }

    public RenderType getRenderType(T entity) {
        if (this.builder.renderTypeFunction != null) {
            try {
                return (RenderType)this.builder.renderTypeFunction.apply(entity);
            }
            catch (RuntimeException e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in renderTypeFunction. Defaulting to RenderType.entityCutoutNoCull()", e);
            }
        }
        return RenderType.m_110458_((ResourceLocation)this.m_5478_(entity));
    }

    public void m_7392_(T pEntity, float pEntityYaw, float pPartialTick, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (this.builder.render != null) {
            ContextUtils.NLRenderContext<T> context = new ContextUtils.NLRenderContext<T>(pEntity, pEntityYaw, pPartialTick, pMatrixStack, pBuffer, pPackedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + pEntity.m_6095_() + "builder for field: render.");
        }
        pMatrixStack.m_85836_();
        if (this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pX != null && this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pY != null && this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pZ != null) {
            float pX = this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pX.floatValue();
            float pY = this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pY.floatValue();
            float pZ = this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pZ.floatValue();
            pMatrixStack.m_85841_(pX, pY, pZ);
        } else {
            pMatrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        }
        pMatrixStack.m_252781_(this.f_114476_.m_253208_());
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose $$6 = pMatrixStack.m_85850_();
        Matrix4f $$7 = $$6.m_252922_();
        Matrix3f $$8 = $$6.m_252943_();
        VertexConsumer $$9 = pBuffer.m_6299_(this.getRenderType(pEntity));
        this.vertex($$9, $$7, $$8, pPackedLight, 0.0f, 0, 0, 1);
        this.vertex($$9, $$7, $$8, pPackedLight, 1.0f, 0, 1, 1);
        this.vertex($$9, $$7, $$8, pPackedLight, 1.0f, 1, 1, 0);
        this.vertex($$9, $$7, $$8, pPackedLight, 0.0f, 1, 0, 0);
        pMatrixStack.m_85849_();
        super.m_7392_(pEntity, pEntityYaw, pPartialTick, pMatrixStack, pBuffer, pPackedLight);
    }

    public void vertex(VertexConsumer p_114090_, Matrix4f p_114091_, Matrix3f p_114092_, int p_114093_, float p_114094_, int p_114095_, int p_114096_, int p_114097_) {
        if (this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vX != null && this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vY != null && this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vZ != null) {
            float vX = this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vX.floatValue();
            float vY = this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vY.floatValue();
            float vZ = this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vZ.floatValue();
            p_114090_.m_252986_(p_114091_, p_114094_ + vX - 0.5f, (float)p_114095_ + vY - 0.25f, vZ).m_6122_(255, 255, 255, 255).m_7421_((float)p_114096_, (float)p_114097_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114093_).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
        } else {
            p_114090_.m_252986_(p_114091_, p_114094_ - 0.5f, (float)p_114095_ - 0.25f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)p_114096_, (float)p_114097_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114093_).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    public ResourceLocation m_5478_(T entity) {
        if (this.builder != null && this.builder.textureLocation != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.textureLocation.apply(entity), "resourcelocation");
                if (obj != null) {
                    return (ResourceLocation)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for textureLocation: " + obj + ". Must be a ResourceLocation. Defaulting to super method: " + this.getDynamicTextureLocation());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("", e);
            }
        }
        return this.getDynamicTextureLocation();
    }

    private ResourceLocation getDynamicTextureLocation() {
        return new ResourceLocation(this.builder.id.m_135827_() + ":textures/entity/projectiles/" + this.builder.id.m_135815_() + ".png");
    }
}

