/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.item;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;

public class DragonflyArmorItem
extends Item {
    private static final UUID ARMOR_UUID = UUID.fromString("23a017ef-23f2-4e6c-ab8e-8e8d881519ab");
    private static final UUID TOUGHNESS_UUID = UUID.fromString("001f5774-a240-4bbb-903b-f63ebef4076a");
    private final ResourceLocation texture;
    private final Multimap<Attribute, AttributeModifier> attributes;

    public DragonflyArmorItem(ArmorMaterial material, String tierName, Item.Properties properties) {
        this(material, CrittersAndCompanions.createId("textures/entity/dragonfly_armor_" + tierName + ".png"), properties);
    }

    public DragonflyArmorItem(ArmorMaterial material, ResourceLocation tierName, Item.Properties properties) {
        super(properties);
        this.texture = tierName;
        this.attributes = ImmutableMultimap.builder().put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "armor", (double)material.m_7366_(ArmorItem.Type.CHESTPLATE), AttributeModifier.Operation.ADDITION)).put((Object)Attributes.f_22285_, (Object)new AttributeModifier(TOUGHNESS_UUID, "toughness", (double)material.m_6651_(), AttributeModifier.Operation.ADDITION)).build();
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.CHEST) {
            return this.attributes;
        }
        return ImmutableMultimap.of();
    }
}

