/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.PlatStuff;

public class C2STeleportPacket
implements Message {
    private final int x;
    private final int z;
    private final Integer y;
    private final ResourceKey<Level> dimension;

    public C2STeleportPacket(FriendlyByteBuf buf) {
        this.x = buf.m_130242_();
        this.z = buf.m_130242_();
        this.y = buf.m_236860_(FriendlyByteBuf::m_130242_).orElse(null);
        this.dimension = buf.m_236801_(Registries.f_256858_);
    }

    public C2STeleportPacket(int x, int z, @Nullable Integer y, ResourceKey<Level> dimension) {
        this.x = x;
        this.z = z;
        this.y = y;
        this.dimension = dimension;
    }

    private static boolean performTeleport(ServerPlayer player, ServerLevel pLevel, double pX, double pY, double pZ) {
        Pair<Boolean, Vec3> result = PlatStuff.fireTeleportEvent(player, pX, pY, pZ);
        if (((Boolean)result.getFirst()).booleanValue()) {
            return false;
        }
        pX = ((Vec3)result.getSecond()).f_82479_;
        pY = ((Vec3)result.getSecond()).f_82480_;
        pZ = ((Vec3)result.getSecond()).f_82481_;
        BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pY, (double)pZ);
        if (Level.m_46741_((BlockPos)blockpos) && player.m_264318_(pLevel, pX, pY, pZ, EnumSet.noneOf(RelativeMovement.class), player.m_146908_(), player.m_146909_())) {
            if (!player.m_21255_()) {
                player.m_20256_(player.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, -5.0, 0.0));
                player.m_6853_(true);
            }
            return true;
        }
        return false;
    }

    private static String formatDouble(double pValue) {
        return String.format(Locale.ROOT, "%f", pValue);
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130130_(this.x);
        buf.m_130130_(this.z);
        buf.m_236835_(Optional.ofNullable(this.y), FriendlyByteBuf::m_130130_);
        buf.m_236858_(this.dimension);
    }

    public void handle(ChannelHandler.Context context) {
        int y;
        Player player = context.getSender();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = player2.m_20194_().m_129880_(this.dimension);
        if (this.y == null) {
            LevelChunk lc;
            ChunkAccess chunk = level.m_6522_(SectionPos.m_123171_((int)this.x), SectionPos.m_123171_((int)this.z), ChunkStatus.f_62326_, false);
            if (chunk == null || chunk instanceof LevelChunk && (lc = (LevelChunk)chunk).m_6430_()) {
                y = level.m_151558_();
                MinecraftServer server = level.m_7654_();
                server.m_6937_((Runnable)new TickTask(server.m_129921_(), () -> C2STeleportPacket.performTeleport(player2, level, this.x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, this.x, this.z), this.z)));
            } else {
                y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, this.x, this.z);
            }
        } else {
            y = this.y;
        }
        if (C2STeleportPacket.performTeleport(player2, level, this.x, y, this.z)) {
            player2.m_213846_((Component)Component.m_237110_((String)"commands.teleport.success.location.single", (Object[])new Object[]{player2.m_5446_(), C2STeleportPacket.formatDouble(this.x), C2STeleportPacket.formatDouble(y), C2STeleportPacket.formatDouble(this.z)}));
        } else {
            player2.m_213846_((Component)Component.m_237115_((String)"commands.teleport.invalidPosition"));
        }
    }
}

