/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.integration.moonlight.MoonlightCompat;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class C2S2COpenAtlasScreenPacket
implements Message {
    @Nullable
    private final BlockPos lecternPos;
    private final boolean pinOnly;

    public C2S2COpenAtlasScreenPacket(FriendlyByteBuf buf) {
        this.lecternPos = buf.m_236860_(FriendlyByteBuf::m_130135_).orElse(null);
        this.pinOnly = buf.readBoolean();
    }

    public C2S2COpenAtlasScreenPacket() {
        this(null, false);
    }

    public C2S2COpenAtlasScreenPacket(BlockPos lecternPos, boolean pinOnly) {
        this.lecternPos = lecternPos;
        this.pinOnly = pinOnly;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_236835_(Optional.ofNullable(this.lecternPos), FriendlyByteBuf::m_130064_);
        buf.writeBoolean(this.pinOnly);
    }

    public void handle(ChannelHandler.Context context) {
        if (context.getDirection() == NetworkDir.PLAY_TO_CLIENT) {
            MapAtlasesClient.openScreen(this.lecternPos, this.pinOnly);
        } else {
            Player player = context.getSender();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack atlas = ItemStack.f_41583_;
            if (this.lecternPos != null) {
                BlockEntity blockEntity = player2.m_9236_().m_7702_(this.lecternPos);
                if (blockEntity instanceof LecternBlockEntity) {
                    LecternBlockEntity le = (LecternBlockEntity)blockEntity;
                    atlas = le.m_59566_();
                }
            } else {
                atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player2);
            }
            if (atlas.m_41720_() instanceof MapAtlasItem) {
                if (this.pinOnly) {
                    player2.m_9236_().m_6269_(null, (Entity)player2, SoundEvents.f_12013_, SoundSource.PLAYERS, 1.7f, 2.0f);
                }
                if (this.pinOnly && MapAtlasesMod.MOONLIGHT && MoonlightCompat.maybePlaceMarkerInFront((Player)player2, atlas)) {
                    return;
                }
                MapAtlasItem.syncAndOpenGui(player2, atlas, this.lecternPos, this.pinOnly);
            }
        }
    }
}

