/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.integration.ImmediatelyFastCompat;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;

public abstract class AbstractAtlasWidget {
    public static final int MAP_DIMENSION = 128;
    protected final int atlasesCount;
    protected int mapBlocksSize;
    protected MapDataHolder mapWherePlayerIs;
    protected boolean followingPlayer = true;
    protected double currentXCenter;
    protected double currentZCenter;
    protected float zoomLevel = 3.0f;
    protected boolean rotatesWithPlayer = false;
    protected boolean drawBigPlayerMarker = true;

    protected AbstractAtlasWidget(int atlasesCount) {
        this.atlasesCount = atlasesCount;
    }

    protected void initialize(MapDataHolder newCenter) {
        if (this.mapWherePlayerIs == null || !this.mapWherePlayerIs.slice.isSameGroup(newCenter.slice)) {
            this.zoomLevel = (float)this.atlasesCount * newCenter.type.getDefaultZoomFactor();
        }
        this.mapWherePlayerIs = newCenter;
        this.mapBlocksSize = (1 << this.mapWherePlayerIs.data.f_77890_) * 128;
        this.currentXCenter = this.mapWherePlayerIs.data.f_256718_;
        this.currentZCenter = this.mapWherePlayerIs.data.f_256789_;
    }

    public void drawAtlas(GuiGraphics graphics, int x, int y, int width, int height, Player player, float zoomLevelDim, boolean showBorders, MapType type, int light, @Nullable MapItemSavedData selectedKey) {
        MapAtlasesClient.setIsDrawingAtlas(true);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float widgetScale = (float)width / (float)(this.atlasesCount * 128);
        float zoomScale = (float)this.atlasesCount / zoomLevelDim;
        int intXCenter = (int)this.currentXCenter;
        int intZCenter = (int)this.currentZCenter;
        int scaleIndex = this.mapBlocksSize / 128;
        ColumnPos c = type.getCenter(intXCenter, intZCenter, this.mapBlocksSize);
        int centerMapX = c.f_140723_();
        int centerMapZ = c.f_140724_();
        poseStack.m_252880_((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, 0.0f);
        poseStack.m_85841_(widgetScale * zoomScale, widgetScale * zoomScale, -1.0f);
        MultiBufferSource.BufferSource vcp = graphics.m_280091_();
        Pair outlineHack = Pair.of(new ArrayList(), new ArrayList());
        this.applyScissors(graphics, x, y, x + width, y + height);
        double mapCenterOffsetX = this.currentXCenter - (double)centerMapX;
        double mapCenterOffsetZ = this.currentZCenter - (double)centerMapZ;
        if (this.rotatesWithPlayer) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f - player.m_146908_()));
        }
        poseStack.m_85837_(-mapCenterOffsetX / (double)scaleIndex, -mapCenterOffsetZ / (double)scaleIndex, 0.0);
        double sideLength = (float)this.mapBlocksSize * zoomScale;
        int radius = (int)((float)(this.mapBlocksSize * this.atlasesCount) * 0.71f);
        int o = Mth.m_14167_((float)zoomLevelDim);
        double maxDist = this.rotatesWithPlayer ? Mth.m_144952_((double)((double)radius + sideLength * 0.71)) : (double)(o + 1) * sideLength * 0.5;
        for (int i = o; i >= -o; --i) {
            for (int j = o; j >= -o; --j) {
                boolean shouldDraw;
                double gridCenterI = (double)i * sideLength;
                double gridCenterJ = (double)j * sideLength;
                if (this.rotatesWithPlayer) {
                    double distance = Mth.m_211589_((double)(gridCenterI - mapCenterOffsetZ * (double)zoomScale), (double)(gridCenterJ - mapCenterOffsetX * (double)zoomScale));
                    shouldDraw = distance <= maxDist;
                } else {
                    boolean bl = shouldDraw = Math.abs(gridCenterI - mapCenterOffsetZ * (double)zoomScale) < maxDist && Math.abs(gridCenterJ - mapCenterOffsetX * (double)zoomScale) < maxDist;
                }
                if (!shouldDraw) continue;
                this.getAndDrawMap(player, poseStack, centerMapX, centerMapZ, vcp, (Pair<List<Matrix4f>, List<Matrix4f>>)outlineHack, i, j, light, selectedKey);
            }
        }
        vcp.m_109911_();
        if (showBorders) {
            if (MapAtlasesMod.IMMEDIATELY_FAST) {
                ImmediatelyFastCompat.startBatching();
            }
            VertexConsumer outlineVC = MapAtlasesClient.MAP_BORDER_TEXTURE.m_119194_((MultiBufferSource)vcp, RenderType::m_110497_);
            for (Matrix4f matrix4f : (List)outlineHack.getFirst()) {
                AbstractAtlasWidget.drawOutline(matrix4f, outlineVC, 50);
            }
            VertexConsumer outlineVC2 = MapAtlasesClient.MAP_HOVERED_TEXTURE.m_119194_((MultiBufferSource)vcp, RenderType::m_110497_);
            for (Matrix4f matrix4f : (List)outlineHack.getSecond()) {
                AbstractAtlasWidget.drawOutline(matrix4f, outlineVC2, 200);
            }
            vcp.m_109911_();
            if (MapAtlasesMod.IMMEDIATELY_FAST) {
                ImmediatelyFastCompat.endBatching();
            }
        }
        poseStack.m_85849_();
        graphics.m_280618_();
        MapAtlasesClient.setIsDrawingAtlas(false);
    }

    private static void drawOutline(Matrix4f matrix4f, VertexConsumer outlineVC, int a) {
        float zOffset = -0.01f;
        outlineVC.m_252986_(matrix4f, 0.0f, 128.0f, zOffset).m_6122_(255, 255, 255, a);
        outlineVC.m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        outlineVC.m_252986_(matrix4f, 128.0f, 128.0f, zOffset).m_6122_(255, 255, 255, a);
        outlineVC.m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        outlineVC.m_252986_(matrix4f, 128.0f, 0.0f, zOffset).m_6122_(255, 255, 255, a);
        outlineVC.m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        outlineVC.m_252986_(matrix4f, 0.0f, 0.0f, zOffset).m_6122_(255, 255, 255, a);
        outlineVC.m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected void applyScissors(GuiGraphics graphics, int x, int y, int x1, int y1) {
        graphics.m_280588_(x, y, x1, y1);
    }

    private void getAndDrawMap(Player player, PoseStack poseStack, int centerMapX, int centerMapZ, MultiBufferSource.BufferSource vcp, Pair<List<Matrix4f>, List<Matrix4f>> outlineHack, int i, int j, int light, @Nullable MapItemSavedData selectedData) {
        int reqXCenter = centerMapX + j * this.mapBlocksSize;
        int reqZCenter = centerMapZ + i * this.mapBlocksSize;
        MapDataHolder state = this.getMapWithCenter(reqXCenter, reqZCenter);
        if (state != null) {
            MapItemSavedData data = state.data;
            boolean drawPlayerIcons = !this.drawBigPlayerMarker && data.f_77887_.equals(player.m_9236_().m_46472_());
            this.drawMap(player, poseStack, vcp, outlineHack, i, j, state, drawPlayerIcons, light, selectedData);
        }
    }

    @Nullable
    public abstract MapDataHolder getMapWithCenter(int var1, int var2);

    public void setFollowingPlayer(boolean followingPlayer) {
        this.followingPlayer = followingPlayer;
    }

    private void drawMap(Player player, PoseStack poseStack, MultiBufferSource.BufferSource vcp, Pair<List<Matrix4f>, List<Matrix4f>> outlineHack, int ix, int iy, MapDataHolder state, boolean drawPlayerIcons, int light, @Nullable MapItemSavedData selectedData) {
        int curMapComponentX = 128 * iy - 64;
        int curMapComponentY = 128 * ix - 64;
        poseStack.m_85836_();
        poseStack.m_85837_((double)curMapComponentX, (double)curMapComponentY, 0.0);
        MapItemSavedData data = state.data;
        ArrayList removed = new ArrayList();
        ArrayList<AbstractMap.SimpleEntry<String, MapDecoration>> added = new ArrayList<AbstractMap.SimpleEntry<String, MapDecoration>>();
        for (Map.Entry e : data.f_77894_.entrySet()) {
            MapDecoration dec = (MapDecoration)e.getValue();
            MapDecoration.Type type = dec.m_77803_();
            if (type == MapDecoration.Type.PLAYER_OFF_MAP || type == MapDecoration.Type.PLAYER_OFF_LIMITS) {
                if (data == this.mapWherePlayerIs.data && drawPlayerIcons) {
                    removed.add(e);
                    added.add(new AbstractMap.SimpleEntry<String, MapDecoration>((String)e.getKey(), new MapDecoration(MapDecoration.Type.PLAYER, dec.m_77804_(), dec.m_77805_(), AbstractAtlasWidget.getPlayerMarkerRot(player), dec.m_77810_())));
                    continue;
                }
                removed.add(e);
                continue;
            }
            if (type != MapDecoration.Type.PLAYER) continue;
            if (!drawPlayerIcons || data != this.mapWherePlayerIs.data) {
                removed.add(e);
                continue;
            }
            int i = 1 << data.f_77890_;
            float f = (float)(player.m_20185_() - (double)data.f_256718_) / (float)i;
            float f1 = (float)(player.m_20189_() - (double)data.f_256789_) / (float)i;
            byte b0 = (byte)((double)(f * 2.0f) + 0.5);
            byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
            added.add(new AbstractMap.SimpleEntry<String, MapDecoration>((String)e.getKey(), new MapDecoration(MapDecoration.Type.PLAYER, b0, b1, AbstractAtlasWidget.getPlayerMarkerRot(player), dec.m_77810_())));
        }
        removed.forEach(d -> data.f_77894_.remove(d.getKey()));
        added.forEach(d -> data.f_77894_.put((String)d.getKey(), (MapDecoration)d.getValue()));
        light = MapAtlasesClient.debugIsMapUpdated(light, state.stringId);
        Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(poseStack, (MultiBufferSource)vcp, state.id, data, false, light);
        if (state.data == selectedData) {
            ((List)outlineHack.getSecond()).add(new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_()));
        } else {
            ((List)outlineHack.getFirst()).add(new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_()));
        }
        poseStack.m_85849_();
        for (Map.Entry e : removed) {
            data.f_77894_.put((String)e.getKey(), (MapDecoration)e.getValue());
        }
    }

    private static byte getPlayerMarkerRot(Player p) {
        float pRotation = p.m_146908_();
        pRotation = (float)((double)pRotation + ((double)pRotation < 0.0 ? -8.0 : 8.0));
        return (byte)((double)pRotation * 16.0 / 360.0);
    }

    public static int round(int num, int mod) {
        int t = num % mod;
        if (t < (int)Math.floor((double)mod / 2.0)) {
            return num - t;
        }
        return num + mod - t;
    }
}

