/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.infernalstudios.shieldexp.access.LivingEntityAccess;
import org.infernalstudios.shieldexp.events.ShieldExpansionEvents;

public class SyncBlocking {
    UUID id;
    boolean blocking;

    public SyncBlocking(FriendlyByteBuf buf) {
        this.id = buf.m_130259_();
        this.blocking = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        buf.writeBoolean(this.blocking);
    }

    public SyncBlocking(UUID id, boolean blocking) {
        this.id = id;
        this.blocking = blocking;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handle);
        ctx.get().setPacketHandled(true);
    }

    private void handle() {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.id);
        Item item = player.m_21206_().m_41720_();
        player.m_21051_(Attributes.f_22279_).m_22120_(player.m_20148_());
        LivingEntityAccess.get(player).setBlocking(false);
        LivingEntityAccess.get(player).setParryWindow(0);
        if (player.m_6117_()) {
            if (!player.m_36335_().m_41519_(item)) {
                player.m_36335_().m_41524_(item, ShieldExpansionEvents.getShieldValue(item, "cooldownTicks").intValue());
            }
            player.m_5810_();
        }
    }
}

