/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.utils;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.config.CommonConfig;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.StagesData;
import com.decursioteam.decursio_stages.datagen.utils.IStagesData;
import com.decursioteam.decursio_stages.utils.StageUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="decursio_stages")
public class StagesHandler {
    private static final Map<UUID, IStagesData> GLOBAL_STAGE_DATA = new HashMap<UUID, IStagesData>();
    @OnlyIn(value=Dist.CLIENT)
    private static IStagesData clientData;

    public static Set<String> getStages() {
        HashSet<String> stages = new HashSet<String>();
        RestrictionsData.getRegistry().getRawRestrictions().forEach((name, rawJSON) -> stages.add(rawJSON.getAsJsonObject("Restriction Data").get("stage").getAsString()));
        return stages;
    }

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        File playerFile = StagesHandler.getPlayerFile(event.getPlayerDirectory(), event.getPlayerUUID());
        StagesData playerData = new StagesData();
        if (playerFile.exists()) {
            try {
                CompoundTag tag = NbtIo.m_128953_((File)playerFile);
                playerData.readFromNBT(tag);
                DecursioStages.LOGGER.debug("Loaded {} stages for {}.", (Object)playerData.getStages().size(), (Object)event.getEntity().m_7755_().getString());
            }
            catch (IOException e) {
                DecursioStages.LOGGER.error("Could not read player data for {}.", (Object)event.getEntity().m_7755_().getString());
                DecursioStages.LOGGER.catching((Throwable)e);
            }
        }
        GLOBAL_STAGE_DATA.put(event.getEntity().m_20148_(), playerData);
    }

    @SubscribeEvent
    public static void onPlayerSave(PlayerEvent.SaveToFile event) {
        block5: {
            UUID playerUUID = event.getEntity().m_20148_();
            if (GLOBAL_STAGE_DATA.containsKey(playerUUID)) {
                IStagesData playerData = StagesHandler.getPlayerData(playerUUID);
                File playerFile = StagesHandler.getPlayerFile(event.getPlayerDirectory(), event.getPlayerUUID());
                assert (playerData != null);
                CompoundTag tag = playerData.writeToNBT();
                if (tag != null) {
                    try {
                        NbtIo.m_128955_((CompoundTag)tag, (File)playerFile);
                        DecursioStages.LOGGER.info("Saved {} stages for {}.", (Object)playerData.getStages().size(), (Object)event.getEntity().m_7755_().getString());
                    }
                    catch (IOException e) {
                        if (!((Boolean)CommonConfig.debugMode.get()).booleanValue()) break block5;
                        DecursioStages.LOGGER.error("Could not write player data for {}.", (Object)playerFile.getName());
                        DecursioStages.LOGGER.catching((Throwable)e);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.info("Syncing {} player data with the client", (Object)event.getEntity().m_7755_().getString());
            }
            StageUtil.syncPlayer((ServerPlayer)event.getEntity());
        }
    }

    @Nullable
    public static IStagesData getPlayerData(UUID uuid) {
        return GLOBAL_STAGE_DATA.get(uuid);
    }

    private static File getPlayerFile(File playerDir, String uuid) {
        File saveDir = new File(playerDir, "decursio_stages");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        return new File(saveDir, uuid + ".dat");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IStagesData getClientData() {
        return clientData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setClientData(IStagesData stageData) {
        clientData = stageData;
    }
}

