/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.utils;

import com.decursioteam.decursio_stages.restrictions.ItemRestriction;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NBTComparisonUtil {
    public static final String WILDCARD_MARKER = "*";

    public static boolean areNBTCompoundsEqual(CompoundTag tag1, CompoundTag tag2) {
        if (tag1 == tag2) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        for (String key : tag1.m_128431_()) {
            if (!tag2.m_128441_(key)) {
                return false;
            }
            if (NBTComparisonUtil.areNBTElementsEqual(tag1.m_128423_(key), tag2.m_128423_(key), true)) continue;
            return false;
        }
        return true;
    }

    public static boolean areNBTElementsEqual(Tag element1, Tag element2, boolean element1IsPattern) {
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        if (element1 instanceof StringTag && element1IsPattern) {
            String str = ((StringTag)element1).m_7916_();
            if (WILDCARD_MARKER.equals(str)) {
                return true;
            }
            if (str.contains(WILDCARD_MARKER)) {
                if (!(element2 instanceof StringTag)) {
                    return false;
                }
                String pattern = str.replace(WILDCARD_MARKER, ".*");
                return Pattern.compile(pattern).matcher(((StringTag)element2).m_7916_()).matches();
            }
        }
        if (element1 instanceof ByteTag && element2 instanceof ByteTag) {
            byte b1 = ((ByteTag)element1).m_7063_();
            byte b2 = ((ByteTag)element2).m_7063_();
            if (!(b1 != 0 && b1 != 1 || b2 != 0 && b2 != 1)) {
                return b1 == b2;
            }
        }
        if (element1 instanceof NumericTag && element2 instanceof NumericTag) {
            NumericTag num1 = (NumericTag)element1;
            NumericTag num2 = (NumericTag)element2;
            if (element1 instanceof ByteTag && element2 instanceof ByteTag) {
                byte b1 = ((ByteTag)element1).m_7063_();
                byte b2 = ((ByteTag)element2).m_7063_();
                if (!(b1 != 0 && b1 != 1 || b2 != 0 && b2 != 1)) {
                    return b1 == b2;
                }
            }
            if (NBTComparisonUtil.isIntegerType(num1) && NBTComparisonUtil.isIntegerType(num2)) {
                return num1.m_7046_() == num2.m_7046_();
            }
            return num1.m_7061_() == num2.m_7061_();
        }
        if (element1.getClass() != element2.getClass()) {
            byte value;
            String strValue;
            boolean boolValue;
            byte value2;
            if (element1 instanceof ByteTag && ((value2 = ((ByteTag)element1).m_7063_()) == 0 || value2 == 1)) {
                boolean bl = boolValue = value2 == 1;
                if (element2 instanceof StringTag && ((strValue = ((StringTag)element2).m_7916_()).equalsIgnoreCase("true") || strValue.equalsIgnoreCase("false"))) {
                    return Boolean.parseBoolean(strValue) == boolValue;
                }
            }
            if (element2 instanceof ByteTag && ((value = ((ByteTag)element2).m_7063_()) == 0 || value == 1)) {
                boolean bl = boolValue = value == 1;
                if (element1 instanceof StringTag && ((strValue = ((StringTag)element1).m_7916_()).equalsIgnoreCase("true") || strValue.equalsIgnoreCase("false"))) {
                    return Boolean.parseBoolean(strValue) == boolValue;
                }
            }
            return false;
        }
        if (element1 instanceof CompoundTag) {
            return NBTComparisonUtil.areNBTCompoundsEqual((CompoundTag)element1, (CompoundTag)element2);
        }
        if (element1 instanceof ListTag) {
            ListTag list1 = (ListTag)element1;
            ListTag list2 = (ListTag)element2;
            if (list1.isEmpty() && element1IsPattern) {
                return true;
            }
            if (list1.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list1.size(); ++i) {
                if (NBTComparisonUtil.areNBTElementsEqual(list1.get(i), list2.get(i), element1IsPattern)) continue;
                return false;
            }
            return true;
        }
        return element1.equals(element2);
    }

    private static boolean isIntegerType(NumericTag tag) {
        return tag instanceof ByteTag || tag instanceof ShortTag || tag instanceof IntTag || tag instanceof LongTag;
    }

    public static JsonElement nbtToJson(CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        return (JsonElement)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)nbt);
    }

    public static CompoundTag jsonToNbt(JsonElement json) {
        if (json == null) {
            return null;
        }
        Tag nbtTag = (Tag)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NbtOps.f_128958_, (Object)json);
        if (nbtTag instanceof CompoundTag) {
            return (CompoundTag)nbtTag;
        }
        CompoundTag result = new CompoundTag();
        result.m_128365_("value", nbtTag);
        return result;
    }

    public static CompoundTag parseJsonToNbt(String jsonString) {
        try {
            JsonElement json = JsonParser.parseString((String)jsonString);
            return NBTComparisonUtil.jsonToNbt(json);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean doesItemMatchRestriction(ItemRestriction restrictionItem, ItemStack itemStack) {
        if (!restrictionItem.getItemStack().m_150930_(itemStack.m_41720_())) {
            return false;
        }
        if (restrictionItem.getCompoundNBT() == null) {
            return true;
        }
        if (itemStack.m_41783_() == null) {
            return false;
        }
        return NBTComparisonUtil.areNBTCompoundsEqual(restrictionItem.getCompoundNBT(), itemStack.m_41783_());
    }

    public static CompoundTag createNbtWithWildcard(CompoundTag nbt, String path) {
        if (nbt == null) {
            return null;
        }
        CompoundTag result = nbt.m_6426_();
        String[] parts = path.split("\\.");
        CompoundTag current = result;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!current.m_128425_(part, 10)) {
                CompoundTag newTag = new CompoundTag();
                current.m_128365_(part, (Tag)newTag);
                current = newTag;
                continue;
            }
            current = current.m_128469_(part);
        }
        current.m_128359_(parts[parts.length - 1], WILDCARD_MARKER);
        return result;
    }

    public static boolean hasNbtPath(CompoundTag nbt, String path) {
        if (nbt == null) {
            return false;
        }
        String[] parts = path.split("\\.");
        CompoundTag current = nbt;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!current.m_128425_(parts[i], 10)) {
                return false;
            }
            current = current.m_128469_(parts[i]);
        }
        return current.m_128441_(parts[parts.length - 1]);
    }

    public static Tag getNbtByPath(CompoundTag nbt, String path) {
        if (nbt == null) {
            return null;
        }
        String[] parts = path.split("\\.");
        CompoundTag current = nbt;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!current.m_128425_(parts[i], 10)) {
                return null;
            }
            current = current.m_128469_(parts[i]);
        }
        return current.m_128423_(parts[parts.length - 1]);
    }
}

