/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.restrictions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemRestriction {
    private final ResourceLocation item;
    private CompoundTag compoundTag;

    public ItemRestriction(ResourceLocation item, Optional<CompoundTag> compoundTag) {
        this.item = item;
        compoundTag.ifPresent(x -> {
            this.compoundTag = (CompoundTag)compoundTag.get();
        });
    }

    public static Codec<ItemRestriction> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("item").orElse((Object)new ResourceLocation("")).forGetter(ItemRestriction::getResourceLocation), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").orElse(null).forGetter(itemRestriction -> Optional.ofNullable(itemRestriction.compoundTag))).apply((Applicative)instance, ItemRestriction::new));
    }

    @Nullable
    public CompoundTag getCompoundNBT() {
        return this.compoundTag;
    }

    public ResourceLocation getResourceLocation() {
        return this.item;
    }

    public Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.item);
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)this.getItem());
        if (this.getCompoundNBT() != null) {
            itemStack.m_41751_(this.getCompoundNBT());
        }
        return itemStack;
    }
}

