/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.events;

import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StructureEvents {
    private final Map<UUID, Boolean> playerInStructure = new HashMap<UUID, Boolean>();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.player;
            UUID playerUUID = player.m_20148_();
            Registry.getRestrictions().forEach(restriction -> {
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (!player.m_9236_().f_46443_ && StageUtil.hasStage((Player)player, stage)) {
                    StructureManager structureManager = Objects.requireNonNull(event.player.m_20194_()).m_129880_(player.m_9236_().m_46472_()).m_215010_();
                    if (!RestrictionsData.getRestrictionData(restriction).getData().getStructureList().isEmpty()) {
                        RestrictionsData.getRestrictionData(restriction).getData().getStructureList().forEach(structureRestriction -> {
                            Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(structureRestriction.getStructure());
                            if (structure != null) {
                                boolean isInStructure = structureManager.m_220494_(event.player.m_20097_(), structure).m_73603_();
                                if (isInStructure && !Boolean.TRUE.equals(this.playerInStructure.get(playerUUID))) {
                                    player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"decursio_stages.structure.enter")));
                                    this.playerInStructure.put(playerUUID, true);
                                } else if (!isInStructure && Boolean.TRUE.equals(this.playerInStructure.get(playerUUID))) {
                                    player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"decursio_stages.structure.leave")));
                                    this.playerInStructure.put(playerUUID, false);
                                }
                            }
                        });
                    }
                }
            });
        }
    }
}

