/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.events;

import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.IStagesData;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import com.decursioteam.decursio_stages.utils.Utils;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemEvents {
    @SubscribeEvent
    public void onItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntity() != null) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ItemStack item = event.getItem().m_32055_();
            Registry.getRestrictions().forEach(s -> {
                String stage = RestrictionsData.getRestrictionData(s).getData().getStage().toLowerCase(Locale.ROOT).toLowerCase(Locale.ROOT);
                if (!StageUtil.hasStage((Player)player, stage) && player.f_36096_ != player.f_36095_) {
                    if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getContainerListWhitelist() && ResourceUtil.getContainers(s).contains(player.f_36096_.getClass().getName()) && ResourceUtil.check(s, item, ResourceUtil.CHECK_TYPES.ALL)) {
                        Utils.dropItemStack(event, s, (Player)player, false);
                    }
                    if (RestrictionsData.getRestrictionData(s).getSettingsCodec().getContainerListWhitelist() && !ResourceUtil.getContainers(s).contains(player.f_36096_.getClass().getName()) && ResourceUtil.check(s, item, ResourceUtil.CHECK_TYPES.ALL)) {
                        Utils.dropItemStack(event, s, (Player)player, false);
                    }
                }
                if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getCanPickup() && !StageUtil.hasStage((Player)player, stage) && ResourceUtil.check(s, item, ResourceUtil.CHECK_TYPES.ALL)) {
                    Utils.dropItemStack(event, s, (Player)player, true);
                }
            });
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        IStagesData stageData = StageUtil.getPlayerData((Player)player);
        if (stageData == null) {
            return;
        }
        ArrayList<String> playerStages = stageData.getStages();
        Registry.getRestrictions().forEach(s -> {
            String stage = RestrictionsData.getRestrictionData(s).getData().getStage().toLowerCase(Locale.ROOT).toLowerCase(Locale.ROOT);
            if (RestrictionsData.getRestrictionData(s).getSettingsCodec().getAdvancedTooltips().equals("NONE")) {
                return;
            }
            if (RestrictionsData.getRestrictionData(s).getSettingsCodec().getAdvancedTooltips().equals("ADVANCED") && !playerStages.contains(stage) && event.getFlags().m_7050_() || !playerStages.contains(stage) && RestrictionsData.getRestrictionData(s).getSettingsCodec().getAdvancedTooltips().equals("ALWAYS")) {
                ItemStack itemStack = null;
                if (ResourceUtil.check(s, event.getItemStack(), ResourceUtil.CHECK_TYPES.ALL)) {
                    itemStack = event.getItemStack();
                }
                if (itemStack != null) {
                    if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getItemTitle().isEmpty()) {
                        event.getToolTip().set(0, Component.m_237113_((String)RestrictionsData.getRestrictionData(s).getSettingsCodec().getItemTitle()));
                    }
                    event.getToolTip().add(Component.m_237115_((String)"decursio_stages.tooltip.stage.message").m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.BOLD).m_7220_((Component)Component.m_237115_((String)"decursio_stages.tooltip.stage.left_bracket").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.DARK_PURPLE)).m_7220_((Component)Component.m_237110_((String)"decursio_stages.tooltip.stage.stage", (Object[])new Object[]{stage}).m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.BOLD)).m_7220_((Component)Component.m_237115_((String)"decursio_stages.tooltip.stage.right_bracket").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.DARK_PURPLE)));
                    if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getCanPickup()) {
                        event.getToolTip().add(Component.m_237115_((String)"decursio_stages.tooltip.pickup").m_130940_(ChatFormatting.WHITE));
                    }
                    if (RestrictionsData.getRestrictionData(s).getSettingsCodec().getCheckPlayerInventory()) {
                        event.getToolTip().add(Component.m_237115_((String)"decursio_stages.tooltip.playerinventory").m_130940_(ChatFormatting.WHITE));
                    }
                    if (RestrictionsData.getRestrictionData(s).getSettingsCodec().getCheckPlayerEquipment()) {
                        event.getToolTip().add(Component.m_237115_((String)"decursio_stages.tooltip.playerequipment").m_130940_(ChatFormatting.WHITE));
                    }
                    if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getUsableItems()) {
                        event.getToolTip().add(Component.m_237115_((String)"decursio_stages.tooltip.usableitems").m_130940_(ChatFormatting.WHITE));
                    }
                    if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getUsableBlocks()) {
                        event.getToolTip().add(Component.m_237115_((String)"decursio_stages.tooltip.usableblocks").m_130940_(ChatFormatting.WHITE));
                    }
                    if (RestrictionsData.getRestrictionData(s).getSettingsCodec().getHideInJEI()) {
                        event.getToolTip().add(Component.m_237115_((String)"decursio_stages.tooltip.hideinjei").m_130940_(ChatFormatting.WHITE));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void onPlayerInteractWithItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity() != null) {
            Player player = event.getEntity();
            Registry.getRestrictions().forEach(s -> {
                String stage = RestrictionsData.getRestrictionData(s).getData().getStage().toLowerCase(Locale.ROOT);
                if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getUsableItems() && !StageUtil.hasStage(player, stage) && ResourceUtil.check(s, event.getItemStack(), ResourceUtil.CHECK_TYPES.ALL)) {
                    event.setCanceled(true);
                    player.m_5661_(Utils.ITEM_INTERACT_ERROR, true);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingAttackEvent event) {
        Entity entity;
        if (event.getSource() != null && (entity = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            if (event.isCancelable() && event.getSource().m_7639_() != null && !event.getSource().m_7639_().m_9236_().f_46443_ && !(event.getSource().m_7639_() instanceof FakePlayer)) {
                Registry.getRestrictions().forEach(s -> {
                    String stage = RestrictionsData.getRestrictionData(s).getData().getStage().toLowerCase(Locale.ROOT);
                    if (!RestrictionsData.getRestrictionData(s).getSettingsCodec().getUsableItems() && !StageUtil.hasStage(player, stage) && ResourceUtil.check(s, player.m_21205_(), ResourceUtil.CHECK_TYPES.ALL)) {
                        event.setCanceled(true);
                        player.m_5661_(Utils.ITEM_INTERACT_ERROR, true);
                    }
                });
            }
        }
    }
}

