/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.events;

import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DimensionEvents {
    @SubscribeEvent
    public void entityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Registry.getRestrictions().forEach(restriction -> {
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (!RestrictionsData.getRestrictionData(restriction).getData().getDimensionList().isEmpty() && !StageUtil.hasStage((Player)player, stage)) {
                    ResourceUtil.getDimensions(restriction).forEach(dimensionRestriction -> {
                        if (dimensionRestriction.getDimension().equals((Object)event.getDimension().m_135782_())) {
                            player.m_5661_((Component)Component.m_237113_((String)dimensionRestriction.getMessage()).m_130940_(ChatFormatting.RED), true);
                            event.setCanceled(true);
                        }
                    });
                }
            });
        }
    }
}

