/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.datagen;

import com.decursioteam.decursio_stages.datagen.utils.IStagesData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class StagesData
implements IStagesData {
    public static final String stagesTag = "Stages";
    private final Set<String> unlockedStages = new HashSet<String>();

    @Override
    public ArrayList<String> getStages() {
        return new ArrayList<String>(this.unlockedStages);
    }

    @Override
    public boolean hasStage(String stage) {
        return this.unlockedStages.contains(stage.toLowerCase());
    }

    @Override
    public void addStage(String stage) {
        this.unlockedStages.add(stage.toLowerCase());
    }

    @Override
    public void removeStage(String stage) {
        this.unlockedStages.remove(stage.toLowerCase());
    }

    @Override
    public void clear() {
        this.unlockedStages.clear();
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_(stagesTag, 8);
        for (int tagIndex = 0; tagIndex < list.size(); ++tagIndex) {
            this.addStage(list.m_128778_(tagIndex));
        }
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (String stage : this.unlockedStages) {
            list.add((Object)StringTag.m_129297_((String)stage));
        }
        tag.m_128365_(stagesTag, (Tag)list);
        return tag;
    }

    public String toString() {
        return "Player Stages [unlockedStages=" + String.valueOf(this.unlockedStages) + "]";
    }
}

