/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.config;

import com.decursioteam.decursio_stages.DecursioStages;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec config;
    public static ForgeConfigSpec.BooleanValue debugMode;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        DecursioStages.LOGGER.info("Loading config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        DecursioStages.LOGGER.info("Built config: " + path);
        file.load();
        DecursioStages.LOGGER.info("Loaded config: " + path);
        config.setConfig((CommentedConfig)file);
    }

    static {
        builder.push("General Options");
        debugMode = builder.comment("   This is an example .json file for a restriction that takes advantage of every feature of the mod. For more information check the wiki https://decursio-team-1.gitbook.io/wiki/mods/decursio-stages\n   \n{\n    \"Restriction Data\": {\n    \"stage\": \"age_1\",\n    \"itemList\": [\n        {\n            \"item\": \"minecraft:chest\",\n            \"nbt\": {\n                \"display\": {\n                    \"Name\": \"[{\\\"text\\\":\\\"Magic Chest\\\",\\\"italic\\\":false}]\"\n                }\n            }\n        }\n    ],\n    \"modList\": [\n        \"minecraft\"\n    ],\n    \"tagList\": [\n        \"minecraft:logs\"\n    ],\n    \"fluidList\": [\n        {\n            \"fluid\": \"minecraft:water\"\n        },\n        {\n            \"tag\": \"lava\"\n        },\n        {\n            \"mod\": \"mekanism\"\n        }\n    ],\n    \"exceptionList\": [\n        {\n            \"item\": \"minecraft:chest\"\n        }\n    ],\n    \"structureList\": [\n        {\n        \"structure\": \"minecraft:village_plains\",\n        \"can_use_block\": false,\n        \"can_place_block\": false,\n        \"can_break_block\": false,\n        \"can_use_block_list\": [\"minecraft:furnace\", \"minecraft:tnt\"],\n        \"can_place_block_list\": [\"minecraft:sand\"],\n        \"can_break_block_list\": []\n        }\n    ],\n    \"mobList\": [\n        {\n        \"spawnType\": [\"NATURAL\", \"MOB_SUMMONED\", \"SPAWN_EGG\", \"COMMAND\"],\n        \"whitelist_blacklist\": \"WHITELIST\",\n        \"entityID\": \"minecraft:zombie\",\n        \"health\": 500,\n        \"effects\": [\n            {\n            \"effect\": \"minecraft:strength\",\n            \"amplifier\": 1,\n            \"duration\": 0,\n            \"chance\": 100\n            }\n        ],\n        \"loadout\": [\n            {\n            \"item\": \"minecraft:egg\",\n            \"slot\": \"MAINHAND\",\n            \"chance\": 100\n            }\n        ]\n        },\n        {\n        \"spawnType\": [\"NATURAL\", \"MOB_SUMMONED\", \"SPAWN_EGG\"],\n        \"whitelist_blacklist\": \"BLACKLIST\",\n        \"entityID\": \"minecraft:skeleton\"\n        }\n    ],\n    \"containerList\": [\n        \"net.minecraft.inventory.container.WorkbenchContainer\"\n    ],\n    \"dimensionList\": [\n        {\n        \"dimension\": \"minecraft:the_nether\",\n        \"message\": \"You're not allowed in this dimension!\"\n        }\n    ]\n    },\n    \"Settings\": {\n    \"advancedTooltips\": \"ALWAYS\",\n    \"dropItemsFromInventory\": true,\n    \"dropArmorFromInventory\": false,\n    \"canPickupItems\": false,\n    \"itemsPickupDelay\": 15,\n    \"hideInJEI_REI\": true,\n    \"canUseItems\": false,\n    \"containerListWhitelist\": false,\n    \"canBreakBlocks\": false,\n    \"canRightClickBlocks\": false,\n    \"applyToFakePlayers\": false,\n    }\n}\n   \n   Set this value to 'true' whenever you're having issues, this will allow the mod to output everything it tries to do in the log.").define("debugMode", false);
        builder.pop();
        config = builder.build();
    }
}

