/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.compat.plugins;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.config.CommonConfig;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.IStagesData;
import com.decursioteam.decursio_stages.events.SyncStagesEvent;
import com.decursioteam.decursio_stages.restrictions.FluidRestriction;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class DecursioStagesJEI
implements IModPlugin {
    private final List<ItemStack> hiddenItems = new ArrayList<ItemStack>();
    private final List<FluidStack> hiddenFluids = new ArrayList<FluidStack>();
    private final HashMap<Recipe<?>, ResourceLocation> hiddenRecipes = new HashMap();
    private IJeiRuntime jeiRuntime;

    public DecursioStagesJEI() {
        if (EffectiveSide.get().isClient()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, SyncStagesEvent.class, e -> this.updateItems(this.jeiRuntime));
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, false, RecipesUpdatedEvent.class, e -> this.updateItems(this.jeiRuntime));
        }
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        this.jeiRuntime = jeiRuntime;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("decursio_stages", "main");
    }

    private void updateItems(IJeiRuntime iJeiRuntime) {
        if (this.jeiRuntime != null) {
            IIngredientManager iIngredientManager = this.jeiRuntime.getIngredientManager();
            this.restoreResources(iIngredientManager);
            this.collectResources(iIngredientManager);
            this.hideResources(iIngredientManager);
        }
    }

    private void restoreResources(IIngredientManager iIngredientManager) {
        if (!this.hiddenItems.isEmpty() || !this.hiddenFluids.isEmpty()) {
            if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.info("Restoring the following items at runtime: {}", this.hiddenItems);
            }
            if (!this.hiddenItems.isEmpty()) {
                iIngredientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.hiddenItems);
            }
            if (!this.hiddenFluids.isEmpty()) {
                iIngredientManager.addIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, this.hiddenFluids);
            }
            this.hiddenItems.clear();
            this.hiddenFluids.clear();
        } else if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.warn("There are no items available for restoring to the JEI ingredient list!");
        }
    }

    private void collectResources(IIngredientManager iIngredientManager) {
        if (this.jeiRuntime != null && iIngredientManager != null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            IStagesData stageData = StageUtil.getPlayerData((Player)player);
            try {
                Registry.getRestrictionsHashSet().forEach(s -> {
                    String stage = RestrictionsData.getRestrictionData(s).getData().getStage();
                    assert (stageData != null);
                    if (!stageData.hasStage(stage) && RestrictionsData.getRestrictionData(s).getSettingsCodec().getHideInJEI()) {
                        if (!ResourceUtil.getFluids(s).isEmpty()) {
                            for (FluidStack allIngredient : iIngredientManager.getAllIngredients((IIngredientType)ForgeTypes.FLUID_STACK)) {
                                for (FluidRestriction fluid : ResourceUtil.getFluids(s)) {
                                    if (fluid.getFluid() != null) {
                                        if (!allIngredient.getFluid().m_6212_(fluid.getFluid())) continue;
                                        this.add(allIngredient);
                                        continue;
                                    }
                                    if (fluid.getTag() != null) {
                                        if (!allIngredient.getFluid().m_205067_(Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).createTagKey(fluid.getTag()))) continue;
                                        this.add(allIngredient);
                                        continue;
                                    }
                                    if (fluid.getMod() == null || !Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)allIngredient.getFluid())).m_135827_().equals(fluid.getMod())) continue;
                                    this.add(allIngredient);
                                }
                            }
                        }
                        if (!ResourceUtil.getMods(s).isEmpty()) {
                            for (ItemStack itemStack : iIngredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
                                if (!ResourceUtil.check(s, itemStack, ResourceUtil.CHECK_TYPES.MOD)) continue;
                                this.add(itemStack);
                            }
                        }
                        if (!ResourceUtil.getTags(s).isEmpty()) {
                            for (ItemStack itemStack : iIngredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
                                if (!ResourceUtil.check(s, itemStack, ResourceUtil.CHECK_TYPES.TAG)) continue;
                                this.add(itemStack);
                            }
                        }
                        if (!ResourceUtil.getItems(s).isEmpty()) {
                            for (ItemStack itemStack : iIngredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
                                if (!ResourceUtil.check(s, itemStack, ResourceUtil.CHECK_TYPES.ITEM)) continue;
                                this.add(itemStack);
                            }
                        }
                    }
                });
            }
            catch (NullPointerException nullPointerException) {}
        } else if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.error("Couldn't collect items that are supposed to be hidden in JEI because JEIRuntime or IngredientManager ar missing! ");
        }
    }

    private void hideResources(IIngredientManager iIngredientManager) {
        if (!this.hiddenItems.isEmpty()) {
            if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.info("Hiding the following items: {}", this.hiddenItems);
            }
            iIngredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.hiddenItems);
        } else if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.warn("The are no items that are supposed to be hidden in JEI");
        }
        if (!this.hiddenFluids.isEmpty()) {
            if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.info("Hiding the following fluids: {}", this.hiddenFluids);
            }
            iIngredientManager.removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, this.hiddenFluids);
        } else if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.warn("The are no fluids that are supposed to be hidden in JEI");
        }
    }

    private void add(ItemStack itemStack) {
        this.hiddenItems.add(itemStack);
    }

    private void add(FluidStack fluidStack) {
        this.hiddenFluids.add(fluidStack);
    }

    private void add(List<ItemStack> itemStacks) {
        this.hiddenItems.addAll(itemStacks);
    }
}

