/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.compat.plugins;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.config.CommonConfig;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.IStagesData;
import com.decursioteam.decursio_stages.events.SyncStagesEvent;
import com.decursioteam.decursio_stages.restrictions.FluidRestriction;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiReloadManager;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;

@EmiEntrypoint
public class DecursioStagesEMI
implements EmiPlugin {
    private static final Set<ResourceLocation> hiddenItemIds = new HashSet<ResourceLocation>();
    private static final Set<EmiStack> hiddenFluidIds = new HashSet<EmiStack>();

    public DecursioStagesEMI() {
        if (EffectiveSide.get().isClient()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, SyncStagesEvent.class, e -> this.reloadEMI());
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, false, RecipesUpdatedEvent.class, e -> this.reloadEMI());
        }
    }

    public void register(EmiRegistry registry) {
        this.collectHiddenResources();
        this.hideResources(registry);
    }

    private void reloadEMI() {
        hiddenItemIds.clear();
        hiddenFluidIds.clear();
        if (Minecraft.m_91087_().f_91073_ != null) {
            EmiReloadManager.reload();
        }
    }

    private void collectHiddenResources() {
        block5: {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            IStagesData stageData = StageUtil.getPlayerData((Player)player);
            if (stageData == null) {
                return;
            }
            try {
                Registry.getRestrictionsHashSet().forEach(s -> {
                    String stage = RestrictionsData.getRestrictionData(s).getData().getStage();
                    if (!stageData.hasStage(stage) && RestrictionsData.getRestrictionData(s).getSettingsCodec().getHideInJEI()) {
                        if (!ResourceUtil.getFluids(s).isEmpty()) {
                            for (FluidRestriction fluid : ResourceUtil.getFluids(s)) {
                                if (fluid.getFluid() != null) {
                                    if (fluid.getFluid() == null) continue;
                                    hiddenFluidIds.add(EmiStack.of((Fluid)fluid.getFluid()));
                                    continue;
                                }
                                if (fluid.getTag() != null) {
                                    ForgeRegistries.FLUIDS.getValues().forEach(fluidEntry -> {
                                        if (fluidEntry.m_205067_(Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).createTagKey(fluid.getTag()))) {
                                            hiddenFluidIds.add(EmiStack.of((Fluid)fluidEntry));
                                        }
                                    });
                                    continue;
                                }
                                if (fluid.getMod() == null) continue;
                                ForgeRegistries.FLUIDS.getValues().forEach(fluidEntry -> {
                                    ResourceLocation fluidId = ForgeRegistries.FLUIDS.getKey(fluidEntry);
                                    if (fluidId != null && fluidId.m_135827_().equals(fluid.getMod())) {
                                        hiddenFluidIds.add(EmiStack.of((Fluid)fluidEntry));
                                    }
                                });
                            }
                        }
                        if (!ResourceUtil.getMods(s).isEmpty()) {
                            ForgeRegistries.ITEMS.getValues().forEach(item -> {
                                ResourceLocation itemId;
                                ItemStack itemStack = new ItemStack((ItemLike)item);
                                if (ResourceUtil.check(s, itemStack, ResourceUtil.CHECK_TYPES.MOD) && (itemId = ForgeRegistries.ITEMS.getKey(item)) != null) {
                                    hiddenItemIds.add(itemId);
                                }
                            });
                        }
                        if (!ResourceUtil.getTags(s).isEmpty()) {
                            ForgeRegistries.ITEMS.getValues().forEach(item -> {
                                ResourceLocation itemId;
                                ItemStack itemStack = new ItemStack((ItemLike)item);
                                if (ResourceUtil.check(s, itemStack, ResourceUtil.CHECK_TYPES.TAG) && (itemId = ForgeRegistries.ITEMS.getKey(item)) != null) {
                                    hiddenItemIds.add(itemId);
                                }
                            });
                        }
                        if (!ResourceUtil.getItems(s).isEmpty()) {
                            ForgeRegistries.ITEMS.getValues().forEach(item -> {
                                ResourceLocation itemId;
                                ItemStack itemStack = new ItemStack((ItemLike)item);
                                if (ResourceUtil.check(s, itemStack, ResourceUtil.CHECK_TYPES.ITEM) && (itemId = ForgeRegistries.ITEMS.getKey(item)) != null) {
                                    hiddenItemIds.add(itemId);
                                }
                            });
                        }
                    }
                });
            }
            catch (Exception e) {
                if (!((Boolean)CommonConfig.debugMode.get()).booleanValue()) break block5;
                DecursioStages.LOGGER.error("Error collecting hidden resources", (Throwable)e);
            }
        }
        if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.info("Total items to hide: {}", (Object)hiddenItemIds.size());
            DecursioStages.LOGGER.info("Total fluids to hide: {}", (Object)hiddenFluidIds.size());
        }
    }

    private void hideResources(EmiRegistry registry) {
        if (hiddenItemIds.isEmpty() && hiddenFluidIds.isEmpty()) {
            if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.warn("No items or fluids to hide in EMI");
            }
            return;
        }
        if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.info("Hiding {} items and {} fluids in EMI", (Object)hiddenItemIds.size(), (Object)hiddenFluidIds.size());
        }
        registry.removeEmiStacks(emiStack -> {
            boolean shouldHide;
            ResourceLocation stackId = emiStack.getId();
            boolean bl = shouldHide = hiddenItemIds.contains(stackId) || hiddenFluidIds.contains(emiStack);
            if (shouldHide && ((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.info("Hiding stack: {}", (Object)stackId);
            }
            return shouldHide;
        });
    }
}

