/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.commands;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.commands.arguments.RestrictionArgumentType;
import com.decursioteam.decursio_stages.commands.arguments.StageArgumentType;
import com.decursioteam.decursio_stages.commands.arguments.TooltipArgumentType;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.FileUtils;
import com.decursioteam.decursio_stages.network.messages.OpenRestrictScreenMessage;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import com.decursioteam.decursio_stages.utils.StagesHandler;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DecStagesCommands {
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"decursio_stages");
    private static final RegistryObject<SingletonArgumentInfo<StageArgumentType>> STAGE_ARGUMENT = COMMAND_ARGUMENT_TYPES.register("stage_argument", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(StageArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(StageArgumentType::new)));
    private static final RegistryObject<SingletonArgumentInfo<RestrictionArgumentType>> RESTRICTION_ARGUMENT = COMMAND_ARGUMENT_TYPES.register("restriction_argument", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(RestrictionArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(RestrictionArgumentType::new)));
    private static final RegistryObject<SingletonArgumentInfo<TooltipArgumentType>> TOOLTIP_ARGUMENT = COMMAND_ARGUMENT_TYPES.register("tooltip_argument", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(TooltipArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(TooltipArgumentType::new)));

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(DecStagesCommands::registerCommands);
        COMMAND_ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"decstages");
        command.then(DecStagesCommands.createSilentStageCommand("add", 2, (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.addStage((CommandContext<CommandSourceStack>)ctx, false)), (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.addStage((CommandContext<CommandSourceStack>)ctx, true))));
        command.then(DecStagesCommands.createSilentStageCommand("remove", 2, (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.removeStage((CommandContext<CommandSourceStack>)ctx, false)), (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.removeStage((CommandContext<CommandSourceStack>)ctx, true))));
        command.then(DecStagesCommands.createPlayerCommand("check", 0, (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.getPlayerStages((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.getPlayerStages((CommandContext<CommandSourceStack>)ctx, false))));
        command.then(DecStagesCommands.createPlayerCommand("clear", 2, (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.clearStages((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.clearStages((CommandContext<CommandSourceStack>)ctx, false))));
        command.then(DecStagesCommands.createPlayerCommand("all", 2, (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.giveStages((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> DecStagesCommands.giveStages((CommandContext<CommandSourceStack>)ctx, false))));
        command.then(DecStagesCommands.createRestrictCommand("restrict", 2, (Command<CommandSourceStack>)((Command)DecStagesCommands::restrictItem)));
        command.then(DecStagesCommands.createInfoCommand("reload", 2, (Command<CommandSourceStack>)((Command)DecStagesCommands::reloadStages)));
        command.then(DecStagesCommands.createLinksCommand("links", 2, (Command<CommandSourceStack>)((Command)DecStagesCommands::linksCommand)));
        command.then(DecStagesCommands.createInfoCommand("info", 2, (Command<CommandSourceStack>)((Command)DecStagesCommands::listStages)));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"gui").requires(sender -> sender.m_6761_(2))).executes(ctx -> {
            try {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
                int windowId = player.f_8940_;
                DecursioStages.LOGGER.info("OpenRestrictScreenCommand: Opening screen for {} with windowId={}", (Object)player.m_7755_().getString(), (Object)windowId);
                DecursioStages.NETWORK.sendToPlayer(player, new OpenRestrictScreenMessage(windowId));
                return 1;
            }
            catch (Exception e) {
                DecursioStages.LOGGER.error("OpenRestrictScreenCommand: Error executing command", (Throwable)e);
                return 0;
            }
        }));
        event.getDispatcher().register(command);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createInfoCommand(String key, int permissions, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).executes(command);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createLinksCommand(String key, int permissions, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createPlayerCommand(String key, int permissions, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).executes(commandNoPlayer)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(command));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createRestrictCommand(String key, int permissions, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).then(Commands.m_82129_((String)"advancedTooltips", (ArgumentType)new TooltipArgumentType()).then(Commands.m_82129_((String)"itemTitle", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(Arrays.asList("\"Locked Item\"", "\"Requires " + StageArgumentType.getStage((CommandContext<CommandSourceStack>)context, "stage") + "\"", "\"Stage: " + StageArgumentType.getStage((CommandContext<CommandSourceStack>)context, "stage") + "\""), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"pickupDelay", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(Arrays.asList("40", "20", "0"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"hideInJEI", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"canPickup", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"containerListWhitelist", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"checkPlayerInventory", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"checkPlayerEquipment", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"usableItems", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"usableBlocks", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"destroyableBlocks", (ArgumentType)BoolArgumentType.bool()).executes(command)))))))))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createSilentStageCommand(String key, int permissions, Command<CommandSourceStack> command, Command<CommandSourceStack> silent) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)).then(Commands.m_82129_((String)"silent", (ArgumentType)BoolArgumentType.bool()).executes(silent))));
    }

    private static int reloadStages(CommandContext<CommandSourceStack> ctx) {
        RestrictionsData.getRegistry().clearRawRestrictionsData();
        Registry.setupRestrictions();
        Registry.registerRestrictionsList();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.reloadstages", (Object[])new Object[]{StagesHandler.getStages()}), true);
        return 0;
    }

    private static int linksCommand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String stage = StageArgumentType.getStage(ctx, "stage");
        HashSet restrictions = new HashSet();
        RestrictionsData.getRegistry().getRawRestrictions().forEach((name, rawJSON) -> {
            if (rawJSON.getAsJsonObject("Restriction Data").get("stage").getAsString().equals(stage)) {
                restrictions.add("\"" + name + ".json\"");
            }
        });
        if (!restrictions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.links.success", (Object[])new Object[]{stage, String.join((CharSequence)", ", restrictions.toArray(new String[0]))}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"decursio_stages.commands.links.failure", (Object[])new Object[]{stage}));
        }
        return 0;
    }

    private static int listStages(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.liststages", (Object[])new Object[]{StagesHandler.getStages()}), true);
        return 0;
    }

    private static int addStage(CommandContext<CommandSourceStack> ctx, boolean silent) throws CommandSyntaxException {
        String stage = StageArgumentType.getStage(ctx, "stage");
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
            if (stage.contains(",")) {
                Set stages = Arrays.stream(stage.split(",")).collect(Collectors.toSet());
                for (String s : stages) {
                    if (StageUtil.hasStage((Player)player, s)) continue;
                    StageUtil.addStage(player, s);
                }
                if (silent && BoolArgumentType.getBool(ctx, (String)"silent")) continue;
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.addstages.success.target", (Object[])new Object[]{stages}), true);
                if (player == ((CommandSourceStack)ctx.getSource()).m_81373_()) continue;
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.addstages.success.sender", (Object[])new Object[]{player.m_5446_(), stages}), true);
                continue;
            }
            if (!StageUtil.hasStage((Player)player, stage)) {
                StageUtil.addStage(player, stage);
            } else if (!silent || !BoolArgumentType.getBool(ctx, (String)"silent")) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"decursio_stages.commands.addstage.failure.target", (Object[])new Object[]{stage}));
                if (player != ((CommandSourceStack)ctx.getSource()).m_81373_()) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"decursio_stages.commands.addstage.failure.sender", (Object[])new Object[]{player.m_5446_(), stage}));
                }
                return 0;
            }
            if (silent && BoolArgumentType.getBool(ctx, (String)"silent")) continue;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.addstage.success.target", (Object[])new Object[]{stage}), true);
            if (player == ((CommandSourceStack)ctx.getSource()).m_81373_()) continue;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.addstage.success.sender", (Object[])new Object[]{player.m_5446_(), stage}), true);
        }
        return 0;
    }

    private static int removeStage(CommandContext<CommandSourceStack> ctx, boolean silent) throws CommandSyntaxException {
        String stage = StageArgumentType.getStage(ctx, "stage");
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
            if (stage.contains(",")) {
                Set stages = Arrays.stream(stage.split(",")).collect(Collectors.toSet());
                for (String s : stages) {
                    if (!StageUtil.hasStage((Player)player, s)) continue;
                    StageUtil.removeStage(player, s);
                }
                if (silent && BoolArgumentType.getBool(ctx, (String)"silent")) continue;
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.removestages.success.target", (Object[])new Object[]{stages}), true);
                if (player == ((CommandSourceStack)ctx.getSource()).m_81373_()) continue;
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.removestages.success.sender", (Object[])new Object[]{player.m_5446_(), stages}), true);
                continue;
            }
            if (StageUtil.hasStage((Player)player, stage)) {
                StageUtil.removeStage(player, stage);
            } else if (!silent || !BoolArgumentType.getBool(ctx, (String)"silent")) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"decursio_stages.commands.removestage.failure.target", (Object[])new Object[]{stage}));
                if (player != ((CommandSourceStack)ctx.getSource()).m_81373_()) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"decursio_stages.commands.removestage.failure.sender", (Object[])new Object[]{player.m_5446_(), stage}));
                }
                return 0;
            }
            if (silent && BoolArgumentType.getBool(ctx, (String)"silent")) continue;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.removestage.success.target", (Object[])new Object[]{stage}), true);
            if (player == ((CommandSourceStack)ctx.getSource()).m_81373_()) continue;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.removestage.success.sender", (Object[])new Object[]{player.m_5446_(), stage}), true);
        }
        return 0;
    }

    private static int getPlayerStages(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        if (hasPlayer) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
                DecStagesCommands.getPlayerStages(ctx, player);
            }
        } else {
            DecStagesCommands.getPlayerStages(ctx, ((CommandSourceStack)ctx.getSource()).m_81375_());
        }
        return 0;
    }

    private static void getPlayerStages(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        String stageInfo = Objects.requireNonNull(StageUtil.getPlayerData((Player)player)).getStages().stream().map(Object::toString).collect(Collectors.joining(", "));
        if (stageInfo.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"decursio_stages.commands.check.failure.empty", (Object[])new Object[]{player.m_5446_()}));
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.check.success.list", (Object[])new Object[]{player.m_5446_(), stageInfo}), false);
        }
    }

    private static int giveStages(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        if (hasPlayer) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
                DecStagesCommands.giveStages(ctx, player);
            }
        } else {
            DecStagesCommands.giveStages(ctx, ((CommandSourceStack)ctx.getSource()).m_81375_());
        }
        return 0;
    }

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "decursio_stages", pathName);
        DecStagesCommands.createDirectory(customPath, pathName);
        return customPath;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            DecursioStages.LOGGER.error("failed to create \"{}\" directory", (Object)dirName);
        }
    }

    private static void giveStages(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        for (String knownStage : StageUtil.getStages()) {
            StageUtil.addStage(player, knownStage);
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"decursio_stages.commands.all.target"), true);
        if (player != ((CommandSourceStack)ctx.getSource()).m_81373_()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.all.sender", (Object[])new Object[]{player.m_5446_()}), true);
        }
    }

    private static int clearStages(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        if (hasPlayer) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
                DecStagesCommands.clearStages(ctx, player);
            }
        } else {
            DecStagesCommands.clearStages(ctx, ((CommandSourceStack)ctx.getSource()).m_81375_());
        }
        return 0;
    }

    private static void clearStages(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        int removedStages = StageUtil.clearStages(player);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.clear.target", (Object[])new Object[]{removedStages}), true);
        if (player != ((CommandSourceStack)ctx.getSource()).m_81373_()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"decursio_stages.commands.clear.sender", (Object[])new Object[]{removedStages, player.m_5446_()}), true);
        }
    }

    private static int restrictItem(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String stage = StageArgumentType.getStage(ctx, "stage");
        String advancedTooltips = StringArgumentType.getString(ctx, (String)"advancedTooltips");
        String itemTitle = StringArgumentType.getString(ctx, (String)"itemTitle");
        int pickupDelay = IntegerArgumentType.getInteger(ctx, (String)"pickupDelay");
        boolean hideInJEI = BoolArgumentType.getBool(ctx, (String)"hideInJEI");
        boolean canPickup = BoolArgumentType.getBool(ctx, (String)"canPickup");
        boolean containerListWhitelist = BoolArgumentType.getBool(ctx, (String)"containerListWhitelist");
        boolean checkPlayerInventory = BoolArgumentType.getBool(ctx, (String)"checkPlayerInventory");
        boolean checkPlayerEquipment = BoolArgumentType.getBool(ctx, (String)"checkPlayerEquipment");
        boolean usableItems = BoolArgumentType.getBool(ctx, (String)"usableItems");
        boolean usableBlocks = BoolArgumentType.getBool(ctx, (String)"usableBlocks");
        boolean destroyableBlocks = BoolArgumentType.getBool(ctx, (String)"destroyableBlocks");
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"decursio_stages.commands.restrictitem.failure.empty_hand"));
            return 0;
        }
        String itemName = ResourceUtil.getRegistryName(heldItem.m_41720_()).toString();
        AtomicInteger counter = new AtomicInteger();
        RestrictionsData.getRegistry().getRawRestrictions().forEach((restriction, x) -> {
            if (FileUtils.restrictionExists(restriction, stage, advancedTooltips, itemTitle, pickupDelay, hideInJEI, canPickup, containerListWhitelist, checkPlayerInventory, checkPlayerEquipment, usableItems, usableBlocks, destroyableBlocks)) {
                FileUtils.restrictItem(stage, advancedTooltips, itemTitle, pickupDelay, hideInJEI, canPickup, containerListWhitelist, checkPlayerInventory, checkPlayerEquipment, usableItems, usableBlocks, destroyableBlocks, heldItem);
                counter.getAndIncrement();
            }
        });
        if (counter.get() == 0) {
            FileUtils.addRestriction(stage, advancedTooltips, itemTitle, pickupDelay, hideInJEI, canPickup, containerListWhitelist, checkPlayerInventory, checkPlayerEquipment, usableItems, usableBlocks, destroyableBlocks);
            FileUtils.restrictItem(stage, advancedTooltips, itemTitle, pickupDelay, hideInJEI, canPickup, containerListWhitelist, checkPlayerInventory, checkPlayerEquipment, usableItems, usableBlocks, destroyableBlocks, heldItem);
        }
        MutableComponent itemComponent = Component.m_237113_((String)itemName).m_130940_(ChatFormatting.AQUA);
        MutableComponent stageComponent = Component.m_237113_((String)stage).m_130940_(ChatFormatting.DARK_PURPLE);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> DecStagesCommands.lambda$restrictItem$40((Component)itemComponent, (Component)stageComponent), true);
        Registry.setupRestrictions();
        Registry.registerRestrictionsList();
        return 1;
    }

    private static /* synthetic */ Component lambda$restrictItem$40(Component itemComponent, Component stageComponent) {
        return Component.m_237110_((String)"decursio_stages.commands.restrictitem.success", (Object[])new Object[]{itemComponent, stageComponent});
    }
}

