/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.client.screens;

import com.decursioteam.decursio_stages.client.screens.RestrictItemContainer;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RestrictMenu
extends AbstractContainerMenu {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"decursio_stages");
    public static final RegistryObject<MenuType<RestrictMenu>> RESTRICT_MENU = MENU_TYPES.register("restrict_menu", () -> IForgeMenuType.create((windowId, inv, data) -> new RestrictMenu(windowId, inv)));
    private final RestrictItemContainer container = new RestrictItemContainer();
    private static final int SLOTS_PER_ROW = 9;
    private static final int VISIBLE_ROWS = 6;

    public RestrictMenu(int windowId, Inventory playerInventory) {
        super((MenuType)RESTRICT_MENU.get(), windowId);
        this.container.m_5856_(playerInventory.f_35978_);
        this.addRestrictionSlots();
        this.addPlayerInventorySlots(playerInventory);
    }

    private void addRestrictionSlots() {
        int visibleSlots = Math.min(this.container.m_6643_(), 54);
        for (int i = 0; i < visibleSlots; ++i) {
            int row = i / 9;
            int col = i % 9;
            this.m_38897_(new Slot(this.container, i, 8 + col * 18, 18 + row * 18){

                public void m_6654_() {
                    super.m_6654_();
                }
            });
        }
    }

    private void addPlayerInventorySlots(Inventory playerInventory) {
        int playerInvY = 140;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, playerInvY + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, playerInvY + 58));
        }
    }

    public int getRequiredHeight() {
        return 218;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack resultStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            resultStack = slotStack.m_41777_();
            int restrictionSlotsCount = Math.min(this.container.m_6643_(), 54);
            if (index < restrictionSlotsCount) {
                if (!this.m_38903_(slotStack, restrictionSlotsCount, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                int firstEmpty = this.container.getFirstEmptySlot();
                if (firstEmpty >= 0 && firstEmpty < restrictionSlotsCount) {
                    if (!this.m_38903_(slotStack, firstEmpty, firstEmpty + 1, false)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return resultStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    public List<ItemStack> getRestrictedItems() {
        return this.container.getAllItems();
    }

    public ItemStack getRestrictedItem(int slot) {
        return this.container.m_8020_(slot);
    }

    public ItemStack getRestrictedItem() {
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void setRestrictedItem(int slot, ItemStack stack) {
        this.container.m_6836_(slot, stack);
        this.m_38946_();
    }

    public void setRestrictedItem(ItemStack stack) {
        int firstEmpty = this.container.getFirstEmptySlot();
        if (firstEmpty >= 0) {
            this.container.m_6836_(firstEmpty, stack);
            this.m_38946_();
        }
    }

    public void clearItems() {
        this.container.m_6211_();
        this.m_38946_();
    }
}

