/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages;

import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.client.HUDOverlay;
import com.decursioteam.decursio_stages.client.screens.RestrictMenu;
import com.decursioteam.decursio_stages.commands.DecStagesCommands;
import com.decursioteam.decursio_stages.config.CommonConfig;
import com.decursioteam.decursio_stages.events.BlockEvents;
import com.decursioteam.decursio_stages.events.ContainerEvents;
import com.decursioteam.decursio_stages.events.DimensionEvents;
import com.decursioteam.decursio_stages.events.ItemEvents;
import com.decursioteam.decursio_stages.events.MobEvents;
import com.decursioteam.decursio_stages.events.StructureEvents;
import com.decursioteam.decursio_stages.network.ClientPacketHandler;
import com.decursioteam.decursio_stages.network.MessageHandlers;
import com.decursioteam.decursio_stages.network.ServerPacketHandler;
import com.decursioteam.decursio_stages.network.messages.OpenRestrictScreenMessage;
import com.decursioteam.decursio_stages.network.messages.SaveRestrictionMessage;
import com.decursioteam.decursio_stages.network.messages.SyncStagesMessage;
import com.decursioteam.decursio_stages.utils.NetworkUtil;
import com.decursioteam.decursio_stages.utils.StagesReload;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="decursio_stages")
public class DecursioStages {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "decursio_stages";
    public static final NetworkUtil NETWORK = new NetworkUtil("decursio_stages:main", "7.0.x");

    public DecursioStages() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.config, "decursio_stages/decursio_stages.toml");
        RestrictMenu.MENU_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        NETWORK.registerEnqueuedMessage(SyncStagesMessage.class, ServerPacketHandler::encodeStageMessage, ClientPacketHandler::decodeStageMessage, ClientPacketHandler::processSyncStagesMessage);
        NETWORK.registerEnqueuedMessage(OpenRestrictScreenMessage.class, ServerPacketHandler::encodeOpenRestrictScreenMessage, ClientPacketHandler::decodeOpenRestrictScreenMessage, MessageHandlers::handleOpenRestrictScreen);
        NETWORK.registerEnqueuedMessage(SaveRestrictionMessage.class, ServerPacketHandler::encodeSaveRestrictionMessage, ClientPacketHandler::decodeSaveRestrictionMessage, MessageHandlers::handleSaveRestriction);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        DecStagesCommands.init();
        Registry.setupRestrictions();
        Registry.registerRestrictionsList();
        MinecraftForge.EVENT_BUS.addListener(this::registerReloadListener);
        MinecraftForge.EVENT_BUS.register((Object)new ItemEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ContainerEvents());
        MinecraftForge.EVENT_BUS.register((Object)new MobEvents());
        MinecraftForge.EVENT_BUS.register((Object)new StructureEvents());
        MinecraftForge.EVENT_BUS.register((Object)new DimensionEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        CommonConfig.loadConfig(CommonConfig.config, FMLPaths.CONFIGDIR.get().resolve("decursio_stages/decursio_stages.toml").toString());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(HUDOverlay.class);
    }

    private void registerReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new StagesReload());
    }
}

