/*
 * Decompiled with CFR 0.152.
 */
package elocindev.bossultimatum.mixin;

import elocindev.bossultimatum.config.Configs;
import elocindev.bossultimatum.config.entries.UltimatumConfig;
import elocindev.necronomicon.api.NecUtilsAPI;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerEntityMixin {
    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    public void onDeath(DamageSource damageSource, CallbackInfo ci) {
        UltimatumConfig cfg = Configs.MAIN;
        ServerPlayer player = (ServerPlayer)this;
        ServerLevel world = player.m_284548_();
        for (UltimatumConfig.Ultimatum ultimatum : cfg.ultimatums) {
            Entity entity2;
            if (ultimatum.entity_regex == null || !((entity2 = damageSource.m_7639_()) instanceof LivingEntity)) continue;
            LivingEntity attacker = (LivingEntity)entity2;
            if (ultimatum.direct_kill && NecUtilsAPI.getEntityIdentifier((Entity)attacker).toString().matches(ultimatum.entity_regex)) {
                this.applyUltimatumLogic(attacker, ultimatum, world);
                continue;
            }
            world.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)ultimatum.indirect_radius), entity -> entity.m_21223_() >= (float)ultimatum.minimum_hp).forEach(entity -> {
                if (NecUtilsAPI.getEntityIdentifier((Entity)entity).toString().matches(ultimatum.entity_regex)) {
                    this.applyUltimatumLogic((LivingEntity)entity, ultimatum, world);
                }
            });
        }
    }

    private void applyUltimatumLogic(LivingEntity boss, UltimatumConfig.Ultimatum ultimatum, ServerLevel world) {
        for (UltimatumConfig.InnerHealingConfig healingConfig : ultimatum.healing_events) {
            if (healingConfig.require_difficulty && !healingConfig.difficulty.contains(world.m_46791_().m_19036_())) continue;
            if (healingConfig.ultimatum_heals_maxhp) {
                boss.m_21153_(boss.m_21233_() * healingConfig.ultimatum_death_healing);
            } else {
                boss.m_5634_(healingConfig.ultimatum_death_healing);
            }
            if (!healingConfig.remove_boss_instead_of_healing) continue;
            boss.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

