/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.goal.ReturnToShoreGoal;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IronGolem.class})
public abstract class IronGolemEntityMixin
extends PathfinderMob {
    public IronGolemEntityMixin(EntityType<? extends AbstractGolem> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"})
    public void avoidCactus(EntityType<? extends AbstractGolem> entityType, Level world, CallbackInfo ci) {
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemsAvoidCactus) {
            this.m_21441_(BlockPathTypes.DANGER_OTHER, -1.0f);
        }
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemsAvoidWater) {
            this.m_21441_(BlockPathTypes.WATER, 16.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
        }
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemsAvoidRail) {
            this.m_21441_(BlockPathTypes.RAIL, -1.0f);
        }
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemsAvoidTrapdoor) {
            this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
        }
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemsAvoidPowderedSnow) {
            this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
            this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, 16.0f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canTarget"}, cancellable=true)
    public void replaceCanTarget(EntityType<?> type, CallbackInfoReturnable<Boolean> cir) {
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemsDontAttackPlayer && type == EntityType.f_20532_) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"initGoals"}, at={@At(value="HEAD")}, cancellable=true)
    protected void initGoalsAddReturnToShore(CallbackInfo ci) {
        this.f_21345_.m_25352_(1, (Goal)new ReturnToShoreGoal(this, 1.0));
    }
}

