/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.mixin.MemoryQueryResultAccessorMixin;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableLong;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AcquirePoi.class})
public abstract class FindPointOfInterestTaskMixin {
    private static final long TICKS_PER_DAY = 24000L;
    private static final long TIME_NIGHT = 13000L;
    private static ServerLevel lastUsedWorld;

    @Inject(method={"method_46885"}, at={@At(value="Head")}, cancellable=true)
    private static void dontFindWorkstationsAtNight(boolean onlyRunIfChild, MutableLong mutableLong, Long2ObjectMap objectMap, Predicate predicate, MemoryAccessor result, Optional optional, ServerLevel serverWorld, PathfinderMob entity, long time, CallbackInfoReturnable<Boolean> cir) {
        lastUsedWorld = serverWorld;
        long timeOfDay = serverWorld.m_46468_() % 24000L;
        MemoryQueryResultAccessorMixin accessorMixin = (MemoryQueryResultAccessorMixin)result;
        if (accessorMixin.getMemory() == MemoryModuleType.f_26359_) {
            return;
        }
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.villagersDontLookForWorkstationsAtNight && entity.m_6095_() == EntityType.f_20492_ && timeOfDay > 13000L) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @ModifyArg(method={"method_46885"}, at=@At(value="Invoke", target="Lnet/minecraft/world/poi/PointOfInterestStorage;getSortedTypesAndPositions(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/poi/PointOfInterestStorage$OccupationStatus;)Ljava/util/stream/Stream;"), index=1)
    private static Predicate<BlockPos> filterForOccupiedBeds(Predicate<BlockPos> oldPredicate) {
        Predicate<BlockPos> newPredicate = blockPos -> {
            if (FindPointOfInterestTaskMixin.isBedOccupied(blockPos)) {
                return false;
            }
            return oldPredicate.test((BlockPos)blockPos);
        };
        return newPredicate;
    }

    @ModifyArg(method={"method_46885"}, at=@At(value="Invoke", target="Lnet/minecraft/world/poi/PointOfInterestStorage;getSortedTypesAndPositions(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/poi/PointOfInterestStorage$OccupationStatus;)Ljava/util/stream/Stream;"), index=3)
    private static int increasePOIRange(int radius) {
        return Math.max(radius, LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange);
    }

    private static boolean isBedOccupied(BlockPos pos) {
        BlockState blockState = lastUsedWorld.m_8055_(pos);
        return blockState.m_204336_(BlockTags.f_13038_) && (Boolean)blockState.m_61143_((Property)BedBlock.f_49441_) != false;
    }

    @ModifyArg(method={"findPathToPoi(Lnet/minecraft/entity/mob/MobEntity;Ljava/util/Set;)Lnet/minecraft/entity/ai/pathing/Path;"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/pathing/EntityNavigation;findPathTo(Ljava/util/Set;I)Lnet/minecraft/entity/ai/pathing/Path;"), index=1)
    private static int increaseMinimumPOIClaimDistance(int distance) {
        return Math.max(distance, LibertyVillagersMod.CONFIG.villagerPathfindingConfig.minimumPOISearchDistance);
    }
}

