/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class VillagerSetPOI {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagerSetPOI").executes(context -> {
            VillagerSetPOI.processVillagerSetPOI((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagersetpoi").executes(context -> {
            VillagerSetPOI.processVillagerSetPOI((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"vsp").executes(context -> {
            VillagerSetPOI.processVillagerSetPOI((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
    }

    public static void processVillagerSetPOI(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        ServerPlayer player = source.m_230896_();
        ServerLevel serverWorld = source.m_81372_();
        float maxDistance = 50.0f;
        float tickDelta = 0.0f;
        HitResult hit = player.m_19907_((double)maxDistance, tickDelta, false);
        switch (hit.m_6662_()) {
            case MISS: {
                player.m_5661_((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerSetPOI.miss"), false);
                break;
            }
            case BLOCK: {
                BlockHitResult blockHit = (BlockHitResult)hit;
                BlockPos blockPos = blockHit.m_82425_();
                BlockState blockState = serverWorld.m_8055_(blockPos);
                VillagerSetPOI.handleBlockHit(player, serverWorld, blockPos, blockState);
                break;
            }
            case ENTITY: {
                player.m_5661_((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerSetPOI.entity"), false);
            }
        }
    }

    protected static void handleBlockHit(ServerPlayer player, ServerLevel serverWorld, BlockPos blockPos, BlockState blockState) {
        Block block = blockState.m_60734_();
        MutableComponent name = block.m_49954_();
        Optional optionalRegistryEntry = PoiTypes.m_218075_((BlockState)blockState);
        if (optionalRegistryEntry.isEmpty()) {
            player.m_5661_((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerSetPOI.notPOIType", (Object[])new Object[]{name}), false);
            return;
        }
        Optional optionalRegistryKey = ((Holder)optionalRegistryEntry.get()).m_203543_();
        if (optionalRegistryKey.isEmpty()) {
            player.m_213846_((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerSetPOI.notPOIType", (Object[])new Object[]{name}));
            return;
        }
        String poiTypeName = ((ResourceKey)optionalRegistryKey.get()).m_135782_().toString();
        PoiManager storage = serverWorld.m_8904_();
        if (!storage.m_217874_((ResourceKey)optionalRegistryKey.get(), blockPos)) {
            storage.m_217919_(blockPos, (Holder)optionalRegistryEntry.get());
            DebugPackets.m_133679_((ServerLevel)serverWorld, (BlockPos)blockPos);
            player.m_213846_((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerSetPOI.enable", (Object[])new Object[]{name, poiTypeName}));
        } else {
            storage.m_27079_(blockPos);
            DebugPackets.m_133716_((ServerLevel)serverWorld, (BlockPos)blockPos);
            player.m_213846_((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerSetPOI.disable", (Object[])new Object[]{name, poiTypeName}));
        }
    }
}

