/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.util;

import com.mojang.blaze3d.vertex.PoseStack;
import extensions.net.minecraft.world.entity.Entity.EntityExt;
import extensions.net.minecraft.world.entity.item.ItemEntity.ItemEntityExt;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class GameUtils {
    private GameUtils() {
    }

    public static void sendPlayerMessage(@Nullable Player player, String translationKey, ChatFormatting color, Object ... args) {
        if (player == null) {
            return;
        }
        player.m_213846_((Component)Component.m_237110_((String)String.format("%s.%s.%s", "message", "summoningrituals", translationKey), (Object[])args).m_130940_(color));
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack stack, boolean offset) {
        EntityExt.spawn((Entity)ItemEntityExt.of(level, stack), level, (double)pos.m_123341_() + (offset ? 0.5 : 0.0), (double)pos.m_123342_() + (offset ? 0.5 : 0.0), (double)pos.m_123343_() + (offset ? 0.5 : 0.0));
    }

    public static void playSound(@Nullable Level level, BlockPos pos, SoundEvent sound) {
        if (level == null) {
            return;
        }
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public static void renderCount(GuiGraphics guiGraphics, String text, int x, int y) {
        GameUtils.renderText(guiGraphics, text, ANCHOR.BOTTOM_RIGHT, x + 2, y + 2, 1.0f, 0xFFFFFF);
    }

    public static void renderText(GuiGraphics guiGraphics, String text, ANCHOR anchor, int x, int y, float scale, int color) {
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        stack.m_252880_((float)x, (float)y, 200.0f);
        stack.m_85841_(scale, scale, 1.0f);
        int xOffset = 0;
        int yOffset = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        int width = font.m_92895_(text);
        Objects.requireNonNull(font);
        int height = 9;
        switch (anchor) {
            case TOP_LEFT: {
                break;
            }
            case TOP_RIGHT: {
                xOffset -= width;
                break;
            }
            case BOTTOM_LEFT: {
                yOffset -= height;
                break;
            }
            case BOTTOM_RIGHT: {
                xOffset -= width;
                yOffset -= height;
            }
        }
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, xOffset, yOffset, color, true);
        stack.m_85849_();
    }

    public static enum ANCHOR {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

