/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.network;

import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.network.ServerToClientPacket;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientAltarUpdatePacket
extends ServerToClientPacket<ClientAltarUpdatePacket> {
    private BlockPos pos;
    private PacketType type;
    private int value;

    private ClientAltarUpdatePacket(BlockPos pos, PacketType type, int value) {
        this.pos = pos;
        this.type = type;
        this.value = value;
    }

    ClientAltarUpdatePacket() {
    }

    public static ClientAltarUpdatePacket progressUpdate(BlockPos pos, int progress) {
        return new ClientAltarUpdatePacket(pos, PacketType.PROGRESS, progress);
    }

    public static ClientAltarUpdatePacket processTimeUpdate(BlockPos pos, int processTime) {
        return new ClientAltarUpdatePacket(pos, PacketType.PROCESS_TIME, processTime);
    }

    @Override
    public void encode(ClientAltarUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130068_((Enum)packet.type);
        buffer.writeInt(packet.value);
    }

    @Override
    public ClientAltarUpdatePacket decode(FriendlyByteBuf buffer) {
        return new ClientAltarUpdatePacket(buffer.m_130135_(), (PacketType)buffer.m_130066_(PacketType.class), buffer.readInt());
    }

    @Override
    protected void handlePacket(ClientAltarUpdatePacket packet, ClientLevel level) {
        BlockEntity blockEntity = level.m_7702_(packet.pos);
        if (!(blockEntity instanceof AltarBlockEntity)) {
            return;
        }
        AltarBlockEntity altar = (AltarBlockEntity)blockEntity;
        if (packet.type == PacketType.PROGRESS) {
            altar.setProgress(packet.value);
        } else if (packet.type == PacketType.PROCESS_TIME) {
            altar.setProcessTime(packet.value);
        } else {
            throw new IllegalStateException("Unknown packet type: " + packet.type);
        }
    }

    public static enum PacketType {
        PROGRESS,
        PROCESS_TIME;

    }
}

