/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.inventory;

import com.almostreliable.summoningrituals.inventory.ItemHandler;
import com.almostreliable.summoningrituals.inventory.VanillaWrapper;
import com.almostreliable.summoningrituals.platform.PlatformBlockEntity;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.AltarRecipeSerializer;
import com.almostreliable.summoningrituals.recipe.component.IngredientStack;
import com.almostreliable.summoningrituals.util.GameUtils;
import com.almostreliable.summoningrituals.util.TextUtils;
import extensions.net.minecraft.world.item.ItemStack.ItemStackExt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AltarInventory
implements ItemHandler {
    public static final int SIZE = 64;
    private final PlatformBlockEntity parent;
    private final VanillaWrapper vanillaInv;
    private final Deque<Tuple<ItemStack, Integer>> insertOrder;
    private final NonNullList<ItemStack> items;
    private ItemStack catalyst;

    public AltarInventory(PlatformBlockEntity parent) {
        this.parent = parent;
        this.vanillaInv = new VanillaWrapper(this);
        this.items = NonNullList.m_122780_((int)64, (Object)ItemStack.f_41583_);
        this.catalyst = ItemStack.f_41583_;
        this.insertOrder = new ArrayDeque<Tuple<ItemStack, Integer>>(64);
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag;
        ListTag insertListTag = new ListTag();
        for (Tuple<ItemStack, Integer> e : this.insertOrder) {
            tag = new CompoundTag();
            ((ItemStack)e.m_14418_()).m_41739_(tag);
            tag.m_128405_("slot", ((Integer)e.m_14419_()).intValue());
            insertListTag.add((Object)tag);
        }
        ListTag itemsTag = new ListTag();
        for (int slot = 0; slot < 64; ++slot) {
            if (((ItemStack)this.items.get(slot)).m_41619_()) continue;
            tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            ((ItemStack)this.items.get(slot)).m_41739_(tag);
            itemsTag.add((Object)tag);
        }
        CompoundTag tag2 = new CompoundTag();
        tag2.m_128365_("insert_order", (Tag)insertListTag);
        tag2.m_128365_("items", (Tag)itemsTag);
        tag2.m_128365_("catalyst", (Tag)ItemStackExt.serialize(this.catalyst));
        return tag2;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        int slot;
        this.insertOrder.clear();
        ListTag insertListTag = tag.m_128437_("insert_order", 10);
        for (Tag e : insertListTag) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)e));
            slot = ((CompoundTag)e).m_128451_("slot");
            this.insertOrder.add((Tuple<ItemStack, Integer>)new Tuple((Object)stack, (Object)slot));
        }
        this.items.clear();
        ListTag itemsTag = tag.m_128437_("items", 10);
        for (Tag e : itemsTag) {
            slot = ((CompoundTag)e).m_128451_("slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)e));
            this.items.set(slot, (Object)stack);
        }
        this.catalyst = ItemStack.m_41712_((CompoundTag)tag.m_128469_("catalyst"));
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlot(slot);
        if (slot == AltarRecipeSerializer.MAX_INPUTS) {
            this.catalyst = stack;
            return;
        }
        this.items.set(slot, (Object)stack);
        this.onContentsChanged();
    }

    public ItemStack handleInsertion(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack remaining = stack.m_41777_();
        for (int i = 0; i < AltarRecipeSerializer.MAX_INPUTS; ++i) {
            ItemStack original = remaining.m_41777_();
            if ((remaining = this.insertItem(i, remaining)).m_41619_()) {
                this.insertOrder.push((Tuple<ItemStack, Integer>)new Tuple((Object)original, (Object)i));
                return ItemStack.f_41583_;
            }
            if (remaining.m_41613_() == original.m_41613_()) continue;
            original.m_41774_(remaining.m_41613_());
            this.insertOrder.push((Tuple<ItemStack, Integer>)new Tuple((Object)original, (Object)i));
        }
        return remaining;
    }

    public void popLastInserted() {
        Level level = this.parent.m_58904_();
        assert (level != null && !level.f_46443_);
        if (!this.catalyst.m_41619_()) {
            GameUtils.dropItem(level, this.parent.m_58899_(), this.catalyst, true);
            this.catalyst = ItemStack.f_41583_;
            this.onContentsChanged();
            return;
        }
        if (this.insertOrder.isEmpty()) {
            return;
        }
        Tuple<ItemStack, Integer> last = this.insertOrder.pop();
        ItemStack stack = (ItemStack)last.m_14418_();
        int slot = (Integer)last.m_14419_();
        ((ItemStack)this.items.get(slot)).m_41774_(stack.m_41613_());
        if (((ItemStack)this.items.get(slot)).m_41619_()) {
            this.items.set(slot, (Object)ItemStack.f_41583_);
        }
        this.onContentsChanged();
        GameUtils.dropItem(level, this.parent.m_58899_(), stack, true);
    }

    public void dropContents() {
        Level level = this.parent.m_58904_();
        assert (level != null && !level.f_46443_);
        BlockPos pos = this.parent.m_58899_();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            GameUtils.dropItem(level, pos, stack, false);
        }
        if (!this.catalyst.m_41619_()) {
            GameUtils.dropItem(level, pos, this.catalyst, false);
        }
    }

    public boolean handleRecipe(AltarRecipe recipe) {
        List<ItemStack> itemBackup = this.createItemBackup();
        int toRemove = 0;
        int actualRemoved = 0;
        for (IngredientStack input : recipe.getInputs()) {
            toRemove += input.count();
            int inputRemoved = 0;
            for (ItemStack stack : this.items) {
                if (stack.m_41619_() || !input.ingredient().test(stack)) continue;
                int shrinkCount = Math.min(input.count() - inputRemoved, stack.m_41613_());
                stack.m_41774_(shrinkCount);
                if ((inputRemoved += shrinkCount) < input.count()) continue;
                break;
            }
            actualRemoved += inputRemoved;
        }
        if (actualRemoved < toRemove) {
            this.items.clear();
            for (int i = 0; i < itemBackup.size(); ++i) {
                this.items.add(i, (Object)itemBackup.get(i));
            }
            return false;
        }
        this.catalyst = ItemStack.f_41583_;
        this.rebuildInsertOrder();
        this.onContentsChanged();
        return true;
    }

    private ItemStack insertItem(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.validateSlot(slot);
        ItemStack currentStack = (ItemStack)this.items.get(slot);
        if (currentStack.m_41619_()) {
            this.items.set(slot, (Object)stack);
            this.onContentsChanged();
            return ItemStack.f_41583_;
        }
        if (!ItemStackExt.canStack(currentStack, stack)) {
            return stack;
        }
        int maxCount = this.getMaxStackSize(slot, currentStack);
        int toInsert = Math.min(maxCount - currentStack.m_41613_(), stack.m_41613_());
        if (toInsert <= 0) {
            return stack;
        }
        currentStack.m_41769_(toInsert);
        ItemStack remainder = stack.m_255036_(stack.m_41613_() - toInsert);
        this.onContentsChanged();
        return remainder.m_41619_() ? ItemStack.f_41583_ : remainder;
    }

    private void rebuildInsertOrder() {
        this.insertOrder.clear();
        for (int i = 63; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            this.insertOrder.add((Tuple<ItemStack, Integer>)new Tuple((Object)stack.m_41777_(), (Object)i));
        }
    }

    private void onContentsChanged() {
        this.parent.m_6596_();
        if (this.parent.m_58904_() == null || this.parent.m_58904_().f_46443_) {
            return;
        }
        this.parent.m_58904_().m_7260_(this.parent.m_58899_(), this.parent.m_58900_(), this.parent.m_58900_(), 3);
    }

    private void validateSlot(int slot) {
        if (slot < 0 || slot >= 65) {
            throw new IllegalStateException(TextUtils.f("Slot {} is not in range [0,{})", slot, 65));
        }
    }

    private int getMaxStackSize(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    public int getSlots() {
        return AltarRecipeSerializer.MAX_INPUTS + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlot(slot);
        if (slot == AltarRecipeSerializer.MAX_INPUTS) {
            return this.catalyst;
        }
        return (ItemStack)this.items.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (simulate) {
            return ItemStack.f_41583_;
        }
        return this.parent.handleInteraction(null, stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        this.validateSlot(slot);
        if (slot == AltarRecipeSerializer.MAX_INPUTS) {
            return 1;
        }
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public List<ItemStack> getNoneEmptyItems() {
        return this.items.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
    }

    @Override
    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public void setCatalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        this.onContentsChanged();
    }

    public VanillaWrapper getVanillaInv() {
        return this.vanillaInv;
    }

    private List<ItemStack> createItemBackup() {
        ArrayList<ItemStack> backup = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            backup.add(stack.m_41777_());
        }
        return backup;
    }
}

