/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.terrablenderfix.mixin;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import raccoonman.terrablenderfix.extensions.IExtendedSurfaceContext;
import raccoonman.terrablenderfix.util.SurfaceRegionHolder;

@Mixin(value={SurfaceRules.Context.class})
abstract class MixinContext
implements IExtendedSurfaceContext {
    @Shadow
    @Final
    public ChunkAccess f_189540_;
    @Unique
    @Nullable
    private Set<ResourceKey<Biome>> surroundingBiomes;

    MixinContext() {
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void Context(CallbackInfo callback) {
        WorldGenRegion region = SurfaceRegionHolder.get();
        if (region != null) {
            this.surroundingBiomes = new HashSet<ResourceKey<Biome>>();
            ChunkPos centerPos = this.f_189540_.m_7697_();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    ChunkAccess chunk = region.m_6325_(centerPos.f_45578_ + x, centerPos.f_45579_ + z);
                    for (LevelChunkSection section : chunk.m_7103_()) {
                        section.m_187996_().m_196879_(biome -> biome.m_203543_().ifPresent(this.surroundingBiomes::add));
                    }
                }
            }
        }
    }

    @Override
    public Set<ResourceKey<Biome>> getSurroundingBiomes() {
        return this.surroundingBiomes;
    }
}

