/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.terrablenderfix.mixin;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import raccoonman.terrablenderfix.extensions.IExtendedSurfaceContext;
import raccoonman.terrablenderfix.util.StaticCondition;

@Mixin(targets={"net.minecraft.world.level.levelgen.SurfaceRules$BiomeConditionSource"})
public class MixinBiomeConditionSource {
    @Shadow
    @Final
    Predicate<ResourceKey<Biome>> f_204618_;

    @Inject(at={@At(value="HEAD")}, method={"apply"}, cancellable=true)
    public void apply(SurfaceRules.Context ctx, CallbackInfoReturnable<SurfaceRules.Condition> callback) {
        IExtendedSurfaceContext surfaceContext;
        Set<ResourceKey<Biome>> surroundingBiomes;
        SurfaceRules.Context context = ctx;
        if (context instanceof IExtendedSurfaceContext && (surroundingBiomes = (surfaceContext = (IExtendedSurfaceContext)context).getSurroundingBiomes()) != null) {
            boolean isBiomeNearby = surroundingBiomes.stream().filter(this.f_204618_).findAny().isPresent();
            if (!isBiomeNearby) {
                callback.setReturnValue((Object)StaticCondition.FALSE);
            } else if (surroundingBiomes.size() == 1) {
                callback.setReturnValue((Object)StaticCondition.TRUE);
            }
        }
    }
}

